/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.ConfigurationRecorderSummariesCopier;
import software.amazon.awssdk.services.config.model.ConfigurationRecorderSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfigurationRecordersResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, ListConfigurationRecordersResponse> {
    private static final SdkField<List<ConfigurationRecorderSummary>> CONFIGURATION_RECORDER_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationRecorderSummaries").getter(ListConfigurationRecordersResponse.getter(ListConfigurationRecordersResponse::configurationRecorderSummaries)).setter(ListConfigurationRecordersResponse.setter(Builder::configurationRecorderSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationRecorderSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationRecorderSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListConfigurationRecordersResponse.getter(ListConfigurationRecordersResponse::nextToken)).setter(ListConfigurationRecordersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_RECORDER_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConfigurationRecorderSummaries", CONFIGURATION_RECORDER_SUMMARIES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ConfigurationRecorderSummary> configurationRecorderSummaries;
    private final String nextToken;

    private ListConfigurationRecordersResponse(BuilderImpl builder) {
        super(builder);
        this.configurationRecorderSummaries = builder.configurationRecorderSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConfigurationRecorderSummaries() {
        return this.configurationRecorderSummaries != null && !(this.configurationRecorderSummaries instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationRecorderSummary> configurationRecorderSummaries() {
        return this.configurationRecorderSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationRecorderSummaries() ? this.configurationRecorderSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationRecordersResponse)) {
            return false;
        }
        ListConfigurationRecordersResponse other = (ListConfigurationRecordersResponse)((Object)obj);
        return this.hasConfigurationRecorderSummaries() == other.hasConfigurationRecorderSummaries() && Objects.equals(this.configurationRecorderSummaries(), other.configurationRecorderSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListConfigurationRecordersResponse").add("ConfigurationRecorderSummaries", this.hasConfigurationRecorderSummaries() ? this.configurationRecorderSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationRecorderSummaries": {
                return Optional.ofNullable(clazz.cast(this.configurationRecorderSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationRecordersResponse, T> g) {
        return obj -> g.apply((ListConfigurationRecordersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationRecorderSummary> configurationRecorderSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationRecordersResponse model) {
            super(model);
            this.configurationRecorderSummaries(model.configurationRecorderSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ConfigurationRecorderSummary.Builder> getConfigurationRecorderSummaries() {
            List<ConfigurationRecorderSummary.Builder> result = ConfigurationRecorderSummariesCopier.copyToBuilder(this.configurationRecorderSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationRecorderSummaries(Collection<ConfigurationRecorderSummary.BuilderImpl> configurationRecorderSummaries) {
            this.configurationRecorderSummaries = ConfigurationRecorderSummariesCopier.copyFromBuilder(configurationRecorderSummaries);
        }

        @Override
        public final Builder configurationRecorderSummaries(Collection<ConfigurationRecorderSummary> configurationRecorderSummaries) {
            this.configurationRecorderSummaries = ConfigurationRecorderSummariesCopier.copy(configurationRecorderSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecorderSummaries(ConfigurationRecorderSummary ... configurationRecorderSummaries) {
            this.configurationRecorderSummaries(Arrays.asList(configurationRecorderSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecorderSummaries(Consumer<ConfigurationRecorderSummary.Builder> ... configurationRecorderSummaries) {
            this.configurationRecorderSummaries(Stream.of(configurationRecorderSummaries).map(c -> (ConfigurationRecorderSummary)((ConfigurationRecorderSummary.Builder)ConfigurationRecorderSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConfigurationRecordersResponse build() {
            return new ListConfigurationRecordersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConfigurationRecordersResponse> {
        public Builder configurationRecorderSummaries(Collection<ConfigurationRecorderSummary> var1);

        public Builder configurationRecorderSummaries(ConfigurationRecorderSummary ... var1);

        public Builder configurationRecorderSummaries(Consumer<ConfigurationRecorderSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

