/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ConformancePackEvaluationFilters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConformancePackComplianceDetailsRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, GetConformancePackComplianceDetailsRequest> {
    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConformancePackName").getter(GetConformancePackComplianceDetailsRequest.getter(GetConformancePackComplianceDetailsRequest::conformancePackName)).setter(GetConformancePackComplianceDetailsRequest.setter(Builder::conformancePackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build()}).build();
    private static final SdkField<ConformancePackEvaluationFilters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(GetConformancePackComplianceDetailsRequest.getter(GetConformancePackComplianceDetailsRequest::filters)).setter(GetConformancePackComplianceDetailsRequest.setter(Builder::filters)).constructor(ConformancePackEvaluationFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(GetConformancePackComplianceDetailsRequest.getter(GetConformancePackComplianceDetailsRequest::limit)).setter(GetConformancePackComplianceDetailsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetConformancePackComplianceDetailsRequest.getter(GetConformancePackComplianceDetailsRequest::nextToken)).setter(GetConformancePackComplianceDetailsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_NAME_FIELD, FILTERS_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private final String conformancePackName;
    private final ConformancePackEvaluationFilters filters;
    private final Integer limit;
    private final String nextToken;

    private GetConformancePackComplianceDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.conformancePackName = builder.conformancePackName;
        this.filters = builder.filters;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public final String conformancePackName() {
        return this.conformancePackName;
    }

    public final ConformancePackEvaluationFilters filters() {
        return this.filters;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConformancePackComplianceDetailsRequest)) {
            return false;
        }
        GetConformancePackComplianceDetailsRequest other = (GetConformancePackComplianceDetailsRequest)((Object)obj);
        return Objects.equals(this.conformancePackName(), other.conformancePackName()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetConformancePackComplianceDetailsRequest").add("ConformancePackName", (Object)this.conformancePackName()).add("Filters", (Object)this.filters()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConformancePackName": {
                return Optional.ofNullable(clazz.cast(this.conformancePackName()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConformancePackComplianceDetailsRequest, T> g) {
        return obj -> g.apply((GetConformancePackComplianceDetailsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String conformancePackName;
        private ConformancePackEvaluationFilters filters;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConformancePackComplianceDetailsRequest model) {
            super(model);
            this.conformancePackName(model.conformancePackName);
            this.filters(model.filters);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getConformancePackName() {
            return this.conformancePackName;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        @Override
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final ConformancePackEvaluationFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(ConformancePackEvaluationFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ConformancePackEvaluationFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConformancePackComplianceDetailsRequest build() {
            return new GetConformancePackComplianceDetailsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConformancePackComplianceDetailsRequest> {
        public Builder conformancePackName(String var1);

        public Builder filters(ConformancePackEvaluationFilters var1);

        default public Builder filters(Consumer<ConformancePackEvaluationFilters.Builder> filters) {
            return this.filters((ConformancePackEvaluationFilters)((ConformancePackEvaluationFilters.Builder)ConformancePackEvaluationFilters.builder().applyMutation(filters)).build());
        }

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

