/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse;

public class DescribeRemediationExceptionsPublisher
implements SdkPublisher<DescribeRemediationExceptionsResponse> {
    private final ConfigAsyncClient client;
    private final DescribeRemediationExceptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRemediationExceptionsPublisher(ConfigAsyncClient client, DescribeRemediationExceptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRemediationExceptionsPublisher(ConfigAsyncClient client, DescribeRemediationExceptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRemediationExceptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRemediationExceptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeRemediationExceptionsResponseFetcher
    implements AsyncPageFetcher<DescribeRemediationExceptionsResponse> {
        private DescribeRemediationExceptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRemediationExceptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRemediationExceptionsResponse> nextPage(DescribeRemediationExceptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRemediationExceptionsPublisher.this.client.describeRemediationExceptions(DescribeRemediationExceptionsPublisher.this.firstRequest);
            }
            return DescribeRemediationExceptionsPublisher.this.client.describeRemediationExceptions((DescribeRemediationExceptionsRequest)((Object)DescribeRemediationExceptionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

