/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.DebugLogDeliveryAccountsCopier;
import software.amazon.awssdk.services.config.model.MaximumExecutionFrequency;
import software.amazon.awssdk.services.config.model.OrganizationConfigRuleTriggerTypeNoSN;
import software.amazon.awssdk.services.config.model.OrganizationConfigRuleTriggerTypeNoSNsCopier;
import software.amazon.awssdk.services.config.model.ResourceTypesScopeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationCustomPolicyRuleMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationCustomPolicyRuleMetadata> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(OrganizationCustomPolicyRuleMetadata.getter(OrganizationCustomPolicyRuleMetadata::description)).setter(OrganizationCustomPolicyRuleMetadata.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> ORGANIZATION_CONFIG_RULE_TRIGGER_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationConfigRuleTriggerTypes").getter(OrganizationCustomPolicyRuleMetadata.getter(OrganizationCustomPolicyRuleMetadata::organizationConfigRuleTriggerTypesAsStrings)).setter(OrganizationCustomPolicyRuleMetadata.setter(Builder::organizationConfigRuleTriggerTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleTriggerTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INPUT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputParameters").getter(OrganizationCustomPolicyRuleMetadata.getter(OrganizationCustomPolicyRuleMetadata::inputParameters)).setter(OrganizationCustomPolicyRuleMetadata.setter(Builder::inputParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputParameters").build()}).build();
    private static final SdkField<String> MAXIMUM_EXECUTION_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaximumExecutionFrequency").getter(OrganizationCustomPolicyRuleMetadata.getter(OrganizationCustomPolicyRuleMetadata::maximumExecutionFrequencyAsString)).setter(OrganizationCustomPolicyRuleMetadata.setter(Builder::maximumExecutionFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumExecutionFrequency").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypesScope").getter(OrganizationCustomPolicyRuleMetadata.getter(OrganizationCustomPolicyRuleMetadata::resourceTypesScope)).setter(OrganizationCustomPolicyRuleMetadata.setter(Builder::resourceTypesScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypesScope").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_ID_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdScope").getter(OrganizationCustomPolicyRuleMetadata.getter(OrganizationCustomPolicyRuleMetadata::resourceIdScope)).setter(OrganizationCustomPolicyRuleMetadata.setter(Builder::resourceIdScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdScope").build()}).build();
    private static final SdkField<String> TAG_KEY_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TagKeyScope").getter(OrganizationCustomPolicyRuleMetadata.getter(OrganizationCustomPolicyRuleMetadata::tagKeyScope)).setter(OrganizationCustomPolicyRuleMetadata.setter(Builder::tagKeyScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeyScope").build()}).build();
    private static final SdkField<String> TAG_VALUE_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TagValueScope").getter(OrganizationCustomPolicyRuleMetadata.getter(OrganizationCustomPolicyRuleMetadata::tagValueScope)).setter(OrganizationCustomPolicyRuleMetadata.setter(Builder::tagValueScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValueScope").build()}).build();
    private static final SdkField<String> POLICY_RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyRuntime").getter(OrganizationCustomPolicyRuleMetadata.getter(OrganizationCustomPolicyRuleMetadata::policyRuntime)).setter(OrganizationCustomPolicyRuleMetadata.setter(Builder::policyRuntime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyRuntime").build()}).build();
    private static final SdkField<String> POLICY_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyText").getter(OrganizationCustomPolicyRuleMetadata.getter(OrganizationCustomPolicyRuleMetadata::policyText)).setter(OrganizationCustomPolicyRuleMetadata.setter(Builder::policyText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyText").build()}).build();
    private static final SdkField<List<String>> DEBUG_LOG_DELIVERY_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DebugLogDeliveryAccounts").getter(OrganizationCustomPolicyRuleMetadata.getter(OrganizationCustomPolicyRuleMetadata::debugLogDeliveryAccounts)).setter(OrganizationCustomPolicyRuleMetadata.setter(Builder::debugLogDeliveryAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugLogDeliveryAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, ORGANIZATION_CONFIG_RULE_TRIGGER_TYPES_FIELD, INPUT_PARAMETERS_FIELD, MAXIMUM_EXECUTION_FREQUENCY_FIELD, RESOURCE_TYPES_SCOPE_FIELD, RESOURCE_ID_SCOPE_FIELD, TAG_KEY_SCOPE_FIELD, TAG_VALUE_SCOPE_FIELD, POLICY_RUNTIME_FIELD, POLICY_TEXT_FIELD, DEBUG_LOG_DELIVERY_ACCOUNTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final List<String> organizationConfigRuleTriggerTypes;
    private final String inputParameters;
    private final String maximumExecutionFrequency;
    private final List<String> resourceTypesScope;
    private final String resourceIdScope;
    private final String tagKeyScope;
    private final String tagValueScope;
    private final String policyRuntime;
    private final String policyText;
    private final List<String> debugLogDeliveryAccounts;

    private OrganizationCustomPolicyRuleMetadata(BuilderImpl builder) {
        this.description = builder.description;
        this.organizationConfigRuleTriggerTypes = builder.organizationConfigRuleTriggerTypes;
        this.inputParameters = builder.inputParameters;
        this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
        this.resourceTypesScope = builder.resourceTypesScope;
        this.resourceIdScope = builder.resourceIdScope;
        this.tagKeyScope = builder.tagKeyScope;
        this.tagValueScope = builder.tagValueScope;
        this.policyRuntime = builder.policyRuntime;
        this.policyText = builder.policyText;
        this.debugLogDeliveryAccounts = builder.debugLogDeliveryAccounts;
    }

    public final String description() {
        return this.description;
    }

    public final List<OrganizationConfigRuleTriggerTypeNoSN> organizationConfigRuleTriggerTypes() {
        return OrganizationConfigRuleTriggerTypeNoSNsCopier.copyStringToEnum(this.organizationConfigRuleTriggerTypes);
    }

    public final boolean hasOrganizationConfigRuleTriggerTypes() {
        return this.organizationConfigRuleTriggerTypes != null && !(this.organizationConfigRuleTriggerTypes instanceof SdkAutoConstructList);
    }

    public final List<String> organizationConfigRuleTriggerTypesAsStrings() {
        return this.organizationConfigRuleTriggerTypes;
    }

    public final String inputParameters() {
        return this.inputParameters;
    }

    public final MaximumExecutionFrequency maximumExecutionFrequency() {
        return MaximumExecutionFrequency.fromValue(this.maximumExecutionFrequency);
    }

    public final String maximumExecutionFrequencyAsString() {
        return this.maximumExecutionFrequency;
    }

    public final boolean hasResourceTypesScope() {
        return this.resourceTypesScope != null && !(this.resourceTypesScope instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypesScope() {
        return this.resourceTypesScope;
    }

    public final String resourceIdScope() {
        return this.resourceIdScope;
    }

    public final String tagKeyScope() {
        return this.tagKeyScope;
    }

    public final String tagValueScope() {
        return this.tagValueScope;
    }

    public final String policyRuntime() {
        return this.policyRuntime;
    }

    public final String policyText() {
        return this.policyText;
    }

    public final boolean hasDebugLogDeliveryAccounts() {
        return this.debugLogDeliveryAccounts != null && !(this.debugLogDeliveryAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> debugLogDeliveryAccounts() {
        return this.debugLogDeliveryAccounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationConfigRuleTriggerTypes() ? this.organizationConfigRuleTriggerTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumExecutionFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypesScope() ? this.resourceTypesScope() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKeyScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagValueScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyRuntime());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyText());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDebugLogDeliveryAccounts() ? this.debugLogDeliveryAccounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationCustomPolicyRuleMetadata)) {
            return false;
        }
        OrganizationCustomPolicyRuleMetadata other = (OrganizationCustomPolicyRuleMetadata)obj;
        return Objects.equals(this.description(), other.description()) && this.hasOrganizationConfigRuleTriggerTypes() == other.hasOrganizationConfigRuleTriggerTypes() && Objects.equals(this.organizationConfigRuleTriggerTypesAsStrings(), other.organizationConfigRuleTriggerTypesAsStrings()) && Objects.equals(this.inputParameters(), other.inputParameters()) && Objects.equals(this.maximumExecutionFrequencyAsString(), other.maximumExecutionFrequencyAsString()) && this.hasResourceTypesScope() == other.hasResourceTypesScope() && Objects.equals(this.resourceTypesScope(), other.resourceTypesScope()) && Objects.equals(this.resourceIdScope(), other.resourceIdScope()) && Objects.equals(this.tagKeyScope(), other.tagKeyScope()) && Objects.equals(this.tagValueScope(), other.tagValueScope()) && Objects.equals(this.policyRuntime(), other.policyRuntime()) && Objects.equals(this.policyText(), other.policyText()) && this.hasDebugLogDeliveryAccounts() == other.hasDebugLogDeliveryAccounts() && Objects.equals(this.debugLogDeliveryAccounts(), other.debugLogDeliveryAccounts());
    }

    public final String toString() {
        return ToString.builder((String)"OrganizationCustomPolicyRuleMetadata").add("Description", (Object)this.description()).add("OrganizationConfigRuleTriggerTypes", this.hasOrganizationConfigRuleTriggerTypes() ? this.organizationConfigRuleTriggerTypesAsStrings() : null).add("InputParameters", (Object)this.inputParameters()).add("MaximumExecutionFrequency", (Object)this.maximumExecutionFrequencyAsString()).add("ResourceTypesScope", this.hasResourceTypesScope() ? this.resourceTypesScope() : null).add("ResourceIdScope", (Object)this.resourceIdScope()).add("TagKeyScope", (Object)this.tagKeyScope()).add("TagValueScope", (Object)this.tagValueScope()).add("PolicyRuntime", (Object)this.policyRuntime()).add("PolicyText", (Object)this.policyText()).add("DebugLogDeliveryAccounts", this.hasDebugLogDeliveryAccounts() ? this.debugLogDeliveryAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "OrganizationConfigRuleTriggerTypes": {
                return Optional.ofNullable(clazz.cast(this.organizationConfigRuleTriggerTypesAsStrings()));
            }
            case "InputParameters": {
                return Optional.ofNullable(clazz.cast(this.inputParameters()));
            }
            case "MaximumExecutionFrequency": {
                return Optional.ofNullable(clazz.cast(this.maximumExecutionFrequencyAsString()));
            }
            case "ResourceTypesScope": {
                return Optional.ofNullable(clazz.cast(this.resourceTypesScope()));
            }
            case "ResourceIdScope": {
                return Optional.ofNullable(clazz.cast(this.resourceIdScope()));
            }
            case "TagKeyScope": {
                return Optional.ofNullable(clazz.cast(this.tagKeyScope()));
            }
            case "TagValueScope": {
                return Optional.ofNullable(clazz.cast(this.tagValueScope()));
            }
            case "PolicyRuntime": {
                return Optional.ofNullable(clazz.cast(this.policyRuntime()));
            }
            case "PolicyText": {
                return Optional.ofNullable(clazz.cast(this.policyText()));
            }
            case "DebugLogDeliveryAccounts": {
                return Optional.ofNullable(clazz.cast(this.debugLogDeliveryAccounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationCustomPolicyRuleMetadata, T> g) {
        return obj -> g.apply((OrganizationCustomPolicyRuleMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private List<String> organizationConfigRuleTriggerTypes = DefaultSdkAutoConstructList.getInstance();
        private String inputParameters;
        private String maximumExecutionFrequency;
        private List<String> resourceTypesScope = DefaultSdkAutoConstructList.getInstance();
        private String resourceIdScope;
        private String tagKeyScope;
        private String tagValueScope;
        private String policyRuntime;
        private String policyText;
        private List<String> debugLogDeliveryAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationCustomPolicyRuleMetadata model) {
            this.description(model.description);
            this.organizationConfigRuleTriggerTypesWithStrings(model.organizationConfigRuleTriggerTypes);
            this.inputParameters(model.inputParameters);
            this.maximumExecutionFrequency(model.maximumExecutionFrequency);
            this.resourceTypesScope(model.resourceTypesScope);
            this.resourceIdScope(model.resourceIdScope);
            this.tagKeyScope(model.tagKeyScope);
            this.tagValueScope(model.tagValueScope);
            this.policyRuntime(model.policyRuntime);
            this.policyText(model.policyText);
            this.debugLogDeliveryAccounts(model.debugLogDeliveryAccounts);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getOrganizationConfigRuleTriggerTypes() {
            if (this.organizationConfigRuleTriggerTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationConfigRuleTriggerTypes;
        }

        public final void setOrganizationConfigRuleTriggerTypes(Collection<String> organizationConfigRuleTriggerTypes) {
            this.organizationConfigRuleTriggerTypes = OrganizationConfigRuleTriggerTypeNoSNsCopier.copy(organizationConfigRuleTriggerTypes);
        }

        @Override
        public final Builder organizationConfigRuleTriggerTypesWithStrings(Collection<String> organizationConfigRuleTriggerTypes) {
            this.organizationConfigRuleTriggerTypes = OrganizationConfigRuleTriggerTypeNoSNsCopier.copy(organizationConfigRuleTriggerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConfigRuleTriggerTypesWithStrings(String ... organizationConfigRuleTriggerTypes) {
            this.organizationConfigRuleTriggerTypesWithStrings(Arrays.asList(organizationConfigRuleTriggerTypes));
            return this;
        }

        @Override
        public final Builder organizationConfigRuleTriggerTypes(Collection<OrganizationConfigRuleTriggerTypeNoSN> organizationConfigRuleTriggerTypes) {
            this.organizationConfigRuleTriggerTypes = OrganizationConfigRuleTriggerTypeNoSNsCopier.copyEnumToString(organizationConfigRuleTriggerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConfigRuleTriggerTypes(OrganizationConfigRuleTriggerTypeNoSN ... organizationConfigRuleTriggerTypes) {
            this.organizationConfigRuleTriggerTypes(Arrays.asList(organizationConfigRuleTriggerTypes));
            return this;
        }

        public final String getInputParameters() {
            return this.inputParameters;
        }

        public final void setInputParameters(String inputParameters) {
            this.inputParameters = inputParameters;
        }

        @Override
        public final Builder inputParameters(String inputParameters) {
            this.inputParameters = inputParameters;
            return this;
        }

        public final String getMaximumExecutionFrequency() {
            return this.maximumExecutionFrequency;
        }

        public final void setMaximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
        }

        @Override
        public final Builder maximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        @Override
        public final Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency) {
            this.maximumExecutionFrequency(maximumExecutionFrequency == null ? null : maximumExecutionFrequency.toString());
            return this;
        }

        public final Collection<String> getResourceTypesScope() {
            if (this.resourceTypesScope instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypesScope;
        }

        public final void setResourceTypesScope(Collection<String> resourceTypesScope) {
            this.resourceTypesScope = ResourceTypesScopeCopier.copy(resourceTypesScope);
        }

        @Override
        public final Builder resourceTypesScope(Collection<String> resourceTypesScope) {
            this.resourceTypesScope = ResourceTypesScopeCopier.copy(resourceTypesScope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesScope(String ... resourceTypesScope) {
            this.resourceTypesScope(Arrays.asList(resourceTypesScope));
            return this;
        }

        public final String getResourceIdScope() {
            return this.resourceIdScope;
        }

        public final void setResourceIdScope(String resourceIdScope) {
            this.resourceIdScope = resourceIdScope;
        }

        @Override
        public final Builder resourceIdScope(String resourceIdScope) {
            this.resourceIdScope = resourceIdScope;
            return this;
        }

        public final String getTagKeyScope() {
            return this.tagKeyScope;
        }

        public final void setTagKeyScope(String tagKeyScope) {
            this.tagKeyScope = tagKeyScope;
        }

        @Override
        public final Builder tagKeyScope(String tagKeyScope) {
            this.tagKeyScope = tagKeyScope;
            return this;
        }

        public final String getTagValueScope() {
            return this.tagValueScope;
        }

        public final void setTagValueScope(String tagValueScope) {
            this.tagValueScope = tagValueScope;
        }

        @Override
        public final Builder tagValueScope(String tagValueScope) {
            this.tagValueScope = tagValueScope;
            return this;
        }

        public final String getPolicyRuntime() {
            return this.policyRuntime;
        }

        public final void setPolicyRuntime(String policyRuntime) {
            this.policyRuntime = policyRuntime;
        }

        @Override
        public final Builder policyRuntime(String policyRuntime) {
            this.policyRuntime = policyRuntime;
            return this;
        }

        public final String getPolicyText() {
            return this.policyText;
        }

        public final void setPolicyText(String policyText) {
            this.policyText = policyText;
        }

        @Override
        public final Builder policyText(String policyText) {
            this.policyText = policyText;
            return this;
        }

        public final Collection<String> getDebugLogDeliveryAccounts() {
            if (this.debugLogDeliveryAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.debugLogDeliveryAccounts;
        }

        public final void setDebugLogDeliveryAccounts(Collection<String> debugLogDeliveryAccounts) {
            this.debugLogDeliveryAccounts = DebugLogDeliveryAccountsCopier.copy(debugLogDeliveryAccounts);
        }

        @Override
        public final Builder debugLogDeliveryAccounts(Collection<String> debugLogDeliveryAccounts) {
            this.debugLogDeliveryAccounts = DebugLogDeliveryAccountsCopier.copy(debugLogDeliveryAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder debugLogDeliveryAccounts(String ... debugLogDeliveryAccounts) {
            this.debugLogDeliveryAccounts(Arrays.asList(debugLogDeliveryAccounts));
            return this;
        }

        public OrganizationCustomPolicyRuleMetadata build() {
            return new OrganizationCustomPolicyRuleMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationCustomPolicyRuleMetadata> {
        public Builder description(String var1);

        public Builder organizationConfigRuleTriggerTypesWithStrings(Collection<String> var1);

        public Builder organizationConfigRuleTriggerTypesWithStrings(String ... var1);

        public Builder organizationConfigRuleTriggerTypes(Collection<OrganizationConfigRuleTriggerTypeNoSN> var1);

        public Builder organizationConfigRuleTriggerTypes(OrganizationConfigRuleTriggerTypeNoSN ... var1);

        public Builder inputParameters(String var1);

        public Builder maximumExecutionFrequency(String var1);

        public Builder maximumExecutionFrequency(MaximumExecutionFrequency var1);

        public Builder resourceTypesScope(Collection<String> var1);

        public Builder resourceTypesScope(String ... var1);

        public Builder resourceIdScope(String var1);

        public Builder tagKeyScope(String var1);

        public Builder tagValueScope(String var1);

        public Builder policyRuntime(String var1);

        public Builder policyText(String var1);

        public Builder debugLogDeliveryAccounts(Collection<String> var1);

        public Builder debugLogDeliveryAccounts(String ... var1);
    }
}

