/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest;
import software.amazon.awssdk.services.config.model.ListResourceEvaluationsResponse;
import software.amazon.awssdk.services.config.model.ResourceEvaluation;

public class ListResourceEvaluationsIterable
implements SdkIterable<ListResourceEvaluationsResponse> {
    private final ConfigClient client;
    private final ListResourceEvaluationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceEvaluationsIterable(ConfigClient client, ListResourceEvaluationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListResourceEvaluationsResponseFetcher();
    }

    public Iterator<ListResourceEvaluationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceEvaluation> resourceEvaluations() {
        Function<ListResourceEvaluationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceEvaluations() != null) {
                return response.resourceEvaluations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceEvaluationsResponseFetcher
    implements SyncPageFetcher<ListResourceEvaluationsResponse> {
        private ListResourceEvaluationsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceEvaluationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceEvaluationsResponse nextPage(ListResourceEvaluationsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceEvaluationsIterable.this.client.listResourceEvaluations(ListResourceEvaluationsIterable.this.firstRequest);
            }
            return ListResourceEvaluationsIterable.this.client.listResourceEvaluations((ListResourceEvaluationsRequest)((Object)ListResourceEvaluationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

