/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.services.config.model.ComplianceTypesCopier;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ConfigRuleNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeComplianceByConfigRuleRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, DescribeComplianceByConfigRuleRequest> {
    private static final SdkField<List<String>> CONFIG_RULE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigRuleNames").getter(DescribeComplianceByConfigRuleRequest.getter(DescribeComplianceByConfigRuleRequest::configRuleNames)).setter(DescribeComplianceByConfigRuleRequest.setter(Builder::configRuleNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> COMPLIANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ComplianceTypes").getter(DescribeComplianceByConfigRuleRequest.getter(DescribeComplianceByConfigRuleRequest::complianceTypesAsStrings)).setter(DescribeComplianceByConfigRuleRequest.setter(Builder::complianceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeComplianceByConfigRuleRequest.getter(DescribeComplianceByConfigRuleRequest::nextToken)).setter(DescribeComplianceByConfigRuleRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAMES_FIELD, COMPLIANCE_TYPES_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> configRuleNames;
    private final List<String> complianceTypes;
    private final String nextToken;

    private DescribeComplianceByConfigRuleRequest(BuilderImpl builder) {
        super(builder);
        this.configRuleNames = builder.configRuleNames;
        this.complianceTypes = builder.complianceTypes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConfigRuleNames() {
        return this.configRuleNames != null && !(this.configRuleNames instanceof SdkAutoConstructList);
    }

    public final List<String> configRuleNames() {
        return this.configRuleNames;
    }

    public final List<ComplianceType> complianceTypes() {
        return ComplianceTypesCopier.copyStringToEnum(this.complianceTypes);
    }

    public final boolean hasComplianceTypes() {
        return this.complianceTypes != null && !(this.complianceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> complianceTypesAsStrings() {
        return this.complianceTypes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigRuleNames() ? this.configRuleNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComplianceTypes() ? this.complianceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComplianceByConfigRuleRequest)) {
            return false;
        }
        DescribeComplianceByConfigRuleRequest other = (DescribeComplianceByConfigRuleRequest)((Object)obj);
        return this.hasConfigRuleNames() == other.hasConfigRuleNames() && Objects.equals(this.configRuleNames(), other.configRuleNames()) && this.hasComplianceTypes() == other.hasComplianceTypes() && Objects.equals(this.complianceTypesAsStrings(), other.complianceTypesAsStrings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeComplianceByConfigRuleRequest").add("ConfigRuleNames", this.hasConfigRuleNames() ? this.configRuleNames() : null).add("ComplianceTypes", this.hasComplianceTypes() ? this.complianceTypesAsStrings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleNames": {
                return Optional.ofNullable(clazz.cast(this.configRuleNames()));
            }
            case "ComplianceTypes": {
                return Optional.ofNullable(clazz.cast(this.complianceTypesAsStrings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeComplianceByConfigRuleRequest, T> g) {
        return obj -> g.apply((DescribeComplianceByConfigRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private List<String> configRuleNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> complianceTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComplianceByConfigRuleRequest model) {
            super(model);
            this.configRuleNames(model.configRuleNames);
            this.complianceTypesWithStrings(model.complianceTypes);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getConfigRuleNames() {
            if (this.configRuleNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configRuleNames;
        }

        public final void setConfigRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
        }

        @Override
        @Transient
        public final Builder configRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder configRuleNames(String ... configRuleNames) {
            this.configRuleNames(Arrays.asList(configRuleNames));
            return this;
        }

        public final Collection<String> getComplianceTypes() {
            if (this.complianceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.complianceTypes;
        }

        public final void setComplianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
        }

        @Override
        @Transient
        public final Builder complianceTypesWithStrings(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder complianceTypesWithStrings(String ... complianceTypes) {
            this.complianceTypesWithStrings(Arrays.asList(complianceTypes));
            return this;
        }

        @Override
        @Transient
        public final Builder complianceTypes(Collection<ComplianceType> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copyEnumToString(complianceTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder complianceTypes(ComplianceType ... complianceTypes) {
            this.complianceTypes(Arrays.asList(complianceTypes));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeComplianceByConfigRuleRequest build() {
            return new DescribeComplianceByConfigRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeComplianceByConfigRuleRequest> {
        public Builder configRuleNames(Collection<String> var1);

        public Builder configRuleNames(String ... var1);

        public Builder complianceTypesWithStrings(Collection<String> var1);

        public Builder complianceTypesWithStrings(String ... var1);

        public Builder complianceTypes(Collection<ComplianceType> var1);

        public Builder complianceTypes(ComplianceType ... var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

