/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.Owner;
import software.amazon.awssdk.services.config.model.SourceDetail;
import software.amazon.awssdk.services.config.model.SourceDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Source
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Source> {
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(Source.getter(Source::ownerAsString)).setter(Source.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> SOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceIdentifier").getter(Source.getter(Source::sourceIdentifier)).setter(Source.setter(Builder::sourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIdentifier").build()}).build();
    private static final SdkField<List<SourceDetail>> SOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceDetails").getter(Source.getter(Source::sourceDetails)).setter(Source.setter(Builder::sourceDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_FIELD, SOURCE_IDENTIFIER_FIELD, SOURCE_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String owner;
    private final String sourceIdentifier;
    private final List<SourceDetail> sourceDetails;

    private Source(BuilderImpl builder) {
        this.owner = builder.owner;
        this.sourceIdentifier = builder.sourceIdentifier;
        this.sourceDetails = builder.sourceDetails;
    }

    public final Owner owner() {
        return Owner.fromValue(this.owner);
    }

    public final String ownerAsString() {
        return this.owner;
    }

    public final String sourceIdentifier() {
        return this.sourceIdentifier;
    }

    public final boolean hasSourceDetails() {
        return this.sourceDetails != null && !(this.sourceDetails instanceof SdkAutoConstructList);
    }

    public final List<SourceDetail> sourceDetails() {
        return this.sourceDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceDetails() ? this.sourceDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source)obj;
        return Objects.equals(this.ownerAsString(), other.ownerAsString()) && Objects.equals(this.sourceIdentifier(), other.sourceIdentifier()) && this.hasSourceDetails() == other.hasSourceDetails() && Objects.equals(this.sourceDetails(), other.sourceDetails());
    }

    public final String toString() {
        return ToString.builder((String)"Source").add("Owner", (Object)this.ownerAsString()).add("SourceIdentifier", (Object)this.sourceIdentifier()).add("SourceDetails", this.hasSourceDetails() ? this.sourceDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.ownerAsString()));
            }
            case "SourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceIdentifier()));
            }
            case "SourceDetails": {
                return Optional.ofNullable(clazz.cast(this.sourceDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Source, T> g) {
        return obj -> g.apply((Source)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String owner;
        private String sourceIdentifier;
        private List<SourceDetail> sourceDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            this.owner(model.owner);
            this.sourceIdentifier(model.sourceIdentifier);
            this.sourceDetails(model.sourceDetails);
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        @Transient
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        @Transient
        public final Builder owner(Owner owner) {
            this.owner(owner == null ? null : owner.toString());
            return this;
        }

        public final String getSourceIdentifier() {
            return this.sourceIdentifier;
        }

        public final void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        @Override
        @Transient
        public final Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public final List<SourceDetail.Builder> getSourceDetails() {
            List<SourceDetail.Builder> result = SourceDetailsCopier.copyToBuilder(this.sourceDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceDetails(Collection<SourceDetail.BuilderImpl> sourceDetails) {
            this.sourceDetails = SourceDetailsCopier.copyFromBuilder(sourceDetails);
        }

        @Override
        @Transient
        public final Builder sourceDetails(Collection<SourceDetail> sourceDetails) {
            this.sourceDetails = SourceDetailsCopier.copy(sourceDetails);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sourceDetails(SourceDetail ... sourceDetails) {
            this.sourceDetails(Arrays.asList(sourceDetails));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sourceDetails(Consumer<SourceDetail.Builder> ... sourceDetails) {
            this.sourceDetails(Stream.of(sourceDetails).map(c -> (SourceDetail)((SourceDetail.Builder)SourceDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Source build() {
            return new Source(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Source> {
        public Builder owner(String var1);

        public Builder owner(Owner var1);

        public Builder sourceIdentifier(String var1);

        public Builder sourceDetails(Collection<SourceDetail> var1);

        public Builder sourceDetails(SourceDetail ... var1);

        public Builder sourceDetails(Consumer<SourceDetail.Builder> ... var1);
    }
}

