/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConformancePackInputParameter;
import software.amazon.awssdk.services.config.model.ConformancePackInputParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConformancePackDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConformancePackDetail> {
    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConformancePackName").getter(ConformancePackDetail.getter(ConformancePackDetail::conformancePackName)).setter(ConformancePackDetail.setter(Builder::conformancePackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build()}).build();
    private static final SdkField<String> CONFORMANCE_PACK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConformancePackArn").getter(ConformancePackDetail.getter(ConformancePackDetail::conformancePackArn)).setter(ConformancePackDetail.setter(Builder::conformancePackArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackArn").build()}).build();
    private static final SdkField<String> CONFORMANCE_PACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConformancePackId").getter(ConformancePackDetail.getter(ConformancePackDetail::conformancePackId)).setter(ConformancePackDetail.setter(Builder::conformancePackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackId").build()}).build();
    private static final SdkField<String> DELIVERY_S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryS3Bucket").getter(ConformancePackDetail.getter(ConformancePackDetail::deliveryS3Bucket)).setter(ConformancePackDetail.setter(Builder::deliveryS3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3Bucket").build()}).build();
    private static final SdkField<String> DELIVERY_S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryS3KeyPrefix").getter(ConformancePackDetail.getter(ConformancePackDetail::deliveryS3KeyPrefix)).setter(ConformancePackDetail.setter(Builder::deliveryS3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3KeyPrefix").build()}).build();
    private static final SdkField<List<ConformancePackInputParameter>> CONFORMANCE_PACK_INPUT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConformancePackInputParameters").getter(ConformancePackDetail.getter(ConformancePackDetail::conformancePackInputParameters)).setter(ConformancePackDetail.setter(Builder::conformancePackInputParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackInputParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConformancePackInputParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_REQUESTED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateRequestedTime").getter(ConformancePackDetail.getter(ConformancePackDetail::lastUpdateRequestedTime)).setter(ConformancePackDetail.setter(Builder::lastUpdateRequestedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateRequestedTime").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(ConformancePackDetail.getter(ConformancePackDetail::createdBy)).setter(ConformancePackDetail.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_NAME_FIELD, CONFORMANCE_PACK_ARN_FIELD, CONFORMANCE_PACK_ID_FIELD, DELIVERY_S3_BUCKET_FIELD, DELIVERY_S3_KEY_PREFIX_FIELD, CONFORMANCE_PACK_INPUT_PARAMETERS_FIELD, LAST_UPDATE_REQUESTED_TIME_FIELD, CREATED_BY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String conformancePackName;
    private final String conformancePackArn;
    private final String conformancePackId;
    private final String deliveryS3Bucket;
    private final String deliveryS3KeyPrefix;
    private final List<ConformancePackInputParameter> conformancePackInputParameters;
    private final Instant lastUpdateRequestedTime;
    private final String createdBy;

    private ConformancePackDetail(BuilderImpl builder) {
        this.conformancePackName = builder.conformancePackName;
        this.conformancePackArn = builder.conformancePackArn;
        this.conformancePackId = builder.conformancePackId;
        this.deliveryS3Bucket = builder.deliveryS3Bucket;
        this.deliveryS3KeyPrefix = builder.deliveryS3KeyPrefix;
        this.conformancePackInputParameters = builder.conformancePackInputParameters;
        this.lastUpdateRequestedTime = builder.lastUpdateRequestedTime;
        this.createdBy = builder.createdBy;
    }

    public final String conformancePackName() {
        return this.conformancePackName;
    }

    public final String conformancePackArn() {
        return this.conformancePackArn;
    }

    public final String conformancePackId() {
        return this.conformancePackId;
    }

    public final String deliveryS3Bucket() {
        return this.deliveryS3Bucket;
    }

    public final String deliveryS3KeyPrefix() {
        return this.deliveryS3KeyPrefix;
    }

    public final boolean hasConformancePackInputParameters() {
        return this.conformancePackInputParameters != null && !(this.conformancePackInputParameters instanceof SdkAutoConstructList);
    }

    public final List<ConformancePackInputParameter> conformancePackInputParameters() {
        return this.conformancePackInputParameters;
    }

    public final Instant lastUpdateRequestedTime() {
        return this.lastUpdateRequestedTime;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.conformancePackArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.conformancePackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConformancePackInputParameters() ? this.conformancePackInputParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateRequestedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConformancePackDetail)) {
            return false;
        }
        ConformancePackDetail other = (ConformancePackDetail)obj;
        return Objects.equals(this.conformancePackName(), other.conformancePackName()) && Objects.equals(this.conformancePackArn(), other.conformancePackArn()) && Objects.equals(this.conformancePackId(), other.conformancePackId()) && Objects.equals(this.deliveryS3Bucket(), other.deliveryS3Bucket()) && Objects.equals(this.deliveryS3KeyPrefix(), other.deliveryS3KeyPrefix()) && this.hasConformancePackInputParameters() == other.hasConformancePackInputParameters() && Objects.equals(this.conformancePackInputParameters(), other.conformancePackInputParameters()) && Objects.equals(this.lastUpdateRequestedTime(), other.lastUpdateRequestedTime()) && Objects.equals(this.createdBy(), other.createdBy());
    }

    public final String toString() {
        return ToString.builder((String)"ConformancePackDetail").add("ConformancePackName", (Object)this.conformancePackName()).add("ConformancePackArn", (Object)this.conformancePackArn()).add("ConformancePackId", (Object)this.conformancePackId()).add("DeliveryS3Bucket", (Object)this.deliveryS3Bucket()).add("DeliveryS3KeyPrefix", (Object)this.deliveryS3KeyPrefix()).add("ConformancePackInputParameters", this.hasConformancePackInputParameters() ? this.conformancePackInputParameters() : null).add("LastUpdateRequestedTime", (Object)this.lastUpdateRequestedTime()).add("CreatedBy", (Object)this.createdBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConformancePackName": {
                return Optional.ofNullable(clazz.cast(this.conformancePackName()));
            }
            case "ConformancePackArn": {
                return Optional.ofNullable(clazz.cast(this.conformancePackArn()));
            }
            case "ConformancePackId": {
                return Optional.ofNullable(clazz.cast(this.conformancePackId()));
            }
            case "DeliveryS3Bucket": {
                return Optional.ofNullable(clazz.cast(this.deliveryS3Bucket()));
            }
            case "DeliveryS3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.deliveryS3KeyPrefix()));
            }
            case "ConformancePackInputParameters": {
                return Optional.ofNullable(clazz.cast(this.conformancePackInputParameters()));
            }
            case "LastUpdateRequestedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateRequestedTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConformancePackDetail, T> g) {
        return obj -> g.apply((ConformancePackDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String conformancePackName;
        private String conformancePackArn;
        private String conformancePackId;
        private String deliveryS3Bucket;
        private String deliveryS3KeyPrefix;
        private List<ConformancePackInputParameter> conformancePackInputParameters = DefaultSdkAutoConstructList.getInstance();
        private Instant lastUpdateRequestedTime;
        private String createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ConformancePackDetail model) {
            this.conformancePackName(model.conformancePackName);
            this.conformancePackArn(model.conformancePackArn);
            this.conformancePackId(model.conformancePackId);
            this.deliveryS3Bucket(model.deliveryS3Bucket);
            this.deliveryS3KeyPrefix(model.deliveryS3KeyPrefix);
            this.conformancePackInputParameters(model.conformancePackInputParameters);
            this.lastUpdateRequestedTime(model.lastUpdateRequestedTime);
            this.createdBy(model.createdBy);
        }

        public final String getConformancePackName() {
            return this.conformancePackName;
        }

        @Override
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        public final String getConformancePackArn() {
            return this.conformancePackArn;
        }

        @Override
        public final Builder conformancePackArn(String conformancePackArn) {
            this.conformancePackArn = conformancePackArn;
            return this;
        }

        public final void setConformancePackArn(String conformancePackArn) {
            this.conformancePackArn = conformancePackArn;
        }

        public final String getConformancePackId() {
            return this.conformancePackId;
        }

        @Override
        public final Builder conformancePackId(String conformancePackId) {
            this.conformancePackId = conformancePackId;
            return this;
        }

        public final void setConformancePackId(String conformancePackId) {
            this.conformancePackId = conformancePackId;
        }

        public final String getDeliveryS3Bucket() {
            return this.deliveryS3Bucket;
        }

        @Override
        public final Builder deliveryS3Bucket(String deliveryS3Bucket) {
            this.deliveryS3Bucket = deliveryS3Bucket;
            return this;
        }

        public final void setDeliveryS3Bucket(String deliveryS3Bucket) {
            this.deliveryS3Bucket = deliveryS3Bucket;
        }

        public final String getDeliveryS3KeyPrefix() {
            return this.deliveryS3KeyPrefix;
        }

        @Override
        public final Builder deliveryS3KeyPrefix(String deliveryS3KeyPrefix) {
            this.deliveryS3KeyPrefix = deliveryS3KeyPrefix;
            return this;
        }

        public final void setDeliveryS3KeyPrefix(String deliveryS3KeyPrefix) {
            this.deliveryS3KeyPrefix = deliveryS3KeyPrefix;
        }

        public final List<ConformancePackInputParameter.Builder> getConformancePackInputParameters() {
            List<ConformancePackInputParameter.Builder> result = ConformancePackInputParametersCopier.copyToBuilder(this.conformancePackInputParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder conformancePackInputParameters(Collection<ConformancePackInputParameter> conformancePackInputParameters) {
            this.conformancePackInputParameters = ConformancePackInputParametersCopier.copy(conformancePackInputParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackInputParameters(ConformancePackInputParameter ... conformancePackInputParameters) {
            this.conformancePackInputParameters(Arrays.asList(conformancePackInputParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackInputParameters(Consumer<ConformancePackInputParameter.Builder> ... conformancePackInputParameters) {
            this.conformancePackInputParameters(Stream.of(conformancePackInputParameters).map(c -> (ConformancePackInputParameter)((ConformancePackInputParameter.Builder)ConformancePackInputParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConformancePackInputParameters(Collection<ConformancePackInputParameter.BuilderImpl> conformancePackInputParameters) {
            this.conformancePackInputParameters = ConformancePackInputParametersCopier.copyFromBuilder(conformancePackInputParameters);
        }

        public final Instant getLastUpdateRequestedTime() {
            return this.lastUpdateRequestedTime;
        }

        @Override
        public final Builder lastUpdateRequestedTime(Instant lastUpdateRequestedTime) {
            this.lastUpdateRequestedTime = lastUpdateRequestedTime;
            return this;
        }

        public final void setLastUpdateRequestedTime(Instant lastUpdateRequestedTime) {
            this.lastUpdateRequestedTime = lastUpdateRequestedTime;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public ConformancePackDetail build() {
            return new ConformancePackDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConformancePackDetail> {
        public Builder conformancePackName(String var1);

        public Builder conformancePackArn(String var1);

        public Builder conformancePackId(String var1);

        public Builder deliveryS3Bucket(String var1);

        public Builder deliveryS3KeyPrefix(String var1);

        public Builder conformancePackInputParameters(Collection<ConformancePackInputParameter> var1);

        public Builder conformancePackInputParameters(ConformancePackInputParameter ... var1);

        public Builder conformancePackInputParameters(Consumer<ConformancePackInputParameter.Builder> ... var1);

        public Builder lastUpdateRequestedTime(Instant var1);

        public Builder createdBy(String var1);
    }
}

