/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ExcludedAccountsCopier;
import software.amazon.awssdk.services.config.model.OrganizationCustomRuleMetadata;
import software.amazon.awssdk.services.config.model.OrganizationManagedRuleMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationConfigRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationConfigRule> {
    private static final SdkField<String> ORGANIZATION_CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationConfigRuleName").getter(OrganizationConfigRule.getter(OrganizationConfigRule::organizationConfigRuleName)).setter(OrganizationConfigRule.setter(Builder::organizationConfigRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleName").build()}).build();
    private static final SdkField<String> ORGANIZATION_CONFIG_RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationConfigRuleArn").getter(OrganizationConfigRule.getter(OrganizationConfigRule::organizationConfigRuleArn)).setter(OrganizationConfigRule.setter(Builder::organizationConfigRuleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleArn").build()}).build();
    private static final SdkField<OrganizationManagedRuleMetadata> ORGANIZATION_MANAGED_RULE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OrganizationManagedRuleMetadata").getter(OrganizationConfigRule.getter(OrganizationConfigRule::organizationManagedRuleMetadata)).setter(OrganizationConfigRule.setter(Builder::organizationManagedRuleMetadata)).constructor(OrganizationManagedRuleMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationManagedRuleMetadata").build()}).build();
    private static final SdkField<OrganizationCustomRuleMetadata> ORGANIZATION_CUSTOM_RULE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OrganizationCustomRuleMetadata").getter(OrganizationConfigRule.getter(OrganizationConfigRule::organizationCustomRuleMetadata)).setter(OrganizationConfigRule.setter(Builder::organizationCustomRuleMetadata)).constructor(OrganizationCustomRuleMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationCustomRuleMetadata").build()}).build();
    private static final SdkField<List<String>> EXCLUDED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedAccounts").getter(OrganizationConfigRule.getter(OrganizationConfigRule::excludedAccounts)).setter(OrganizationConfigRule.setter(Builder::excludedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTime").getter(OrganizationConfigRule.getter(OrganizationConfigRule::lastUpdateTime)).setter(OrganizationConfigRule.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_CONFIG_RULE_NAME_FIELD, ORGANIZATION_CONFIG_RULE_ARN_FIELD, ORGANIZATION_MANAGED_RULE_METADATA_FIELD, ORGANIZATION_CUSTOM_RULE_METADATA_FIELD, EXCLUDED_ACCOUNTS_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String organizationConfigRuleName;
    private final String organizationConfigRuleArn;
    private final OrganizationManagedRuleMetadata organizationManagedRuleMetadata;
    private final OrganizationCustomRuleMetadata organizationCustomRuleMetadata;
    private final List<String> excludedAccounts;
    private final Instant lastUpdateTime;

    private OrganizationConfigRule(BuilderImpl builder) {
        this.organizationConfigRuleName = builder.organizationConfigRuleName;
        this.organizationConfigRuleArn = builder.organizationConfigRuleArn;
        this.organizationManagedRuleMetadata = builder.organizationManagedRuleMetadata;
        this.organizationCustomRuleMetadata = builder.organizationCustomRuleMetadata;
        this.excludedAccounts = builder.excludedAccounts;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public final String organizationConfigRuleName() {
        return this.organizationConfigRuleName;
    }

    public final String organizationConfigRuleArn() {
        return this.organizationConfigRuleArn;
    }

    public final OrganizationManagedRuleMetadata organizationManagedRuleMetadata() {
        return this.organizationManagedRuleMetadata;
    }

    public final OrganizationCustomRuleMetadata organizationCustomRuleMetadata() {
        return this.organizationCustomRuleMetadata;
    }

    public final boolean hasExcludedAccounts() {
        return this.excludedAccounts != null && !(this.excludedAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> excludedAccounts() {
        return this.excludedAccounts;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationConfigRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationConfigRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationManagedRuleMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationCustomRuleMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedAccounts() ? this.excludedAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationConfigRule)) {
            return false;
        }
        OrganizationConfigRule other = (OrganizationConfigRule)obj;
        return Objects.equals(this.organizationConfigRuleName(), other.organizationConfigRuleName()) && Objects.equals(this.organizationConfigRuleArn(), other.organizationConfigRuleArn()) && Objects.equals(this.organizationManagedRuleMetadata(), other.organizationManagedRuleMetadata()) && Objects.equals(this.organizationCustomRuleMetadata(), other.organizationCustomRuleMetadata()) && this.hasExcludedAccounts() == other.hasExcludedAccounts() && Objects.equals(this.excludedAccounts(), other.excludedAccounts()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public final String toString() {
        return ToString.builder((String)"OrganizationConfigRule").add("OrganizationConfigRuleName", (Object)this.organizationConfigRuleName()).add("OrganizationConfigRuleArn", (Object)this.organizationConfigRuleArn()).add("OrganizationManagedRuleMetadata", (Object)this.organizationManagedRuleMetadata()).add("OrganizationCustomRuleMetadata", (Object)this.organizationCustomRuleMetadata()).add("ExcludedAccounts", this.hasExcludedAccounts() ? this.excludedAccounts() : null).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.organizationConfigRuleName()));
            }
            case "OrganizationConfigRuleArn": {
                return Optional.ofNullable(clazz.cast(this.organizationConfigRuleArn()));
            }
            case "OrganizationManagedRuleMetadata": {
                return Optional.ofNullable(clazz.cast(this.organizationManagedRuleMetadata()));
            }
            case "OrganizationCustomRuleMetadata": {
                return Optional.ofNullable(clazz.cast(this.organizationCustomRuleMetadata()));
            }
            case "ExcludedAccounts": {
                return Optional.ofNullable(clazz.cast(this.excludedAccounts()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationConfigRule, T> g) {
        return obj -> g.apply((OrganizationConfigRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String organizationConfigRuleName;
        private String organizationConfigRuleArn;
        private OrganizationManagedRuleMetadata organizationManagedRuleMetadata;
        private OrganizationCustomRuleMetadata organizationCustomRuleMetadata;
        private List<String> excludedAccounts = DefaultSdkAutoConstructList.getInstance();
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationConfigRule model) {
            this.organizationConfigRuleName(model.organizationConfigRuleName);
            this.organizationConfigRuleArn(model.organizationConfigRuleArn);
            this.organizationManagedRuleMetadata(model.organizationManagedRuleMetadata);
            this.organizationCustomRuleMetadata(model.organizationCustomRuleMetadata);
            this.excludedAccounts(model.excludedAccounts);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getOrganizationConfigRuleName() {
            return this.organizationConfigRuleName;
        }

        @Override
        public final Builder organizationConfigRuleName(String organizationConfigRuleName) {
            this.organizationConfigRuleName = organizationConfigRuleName;
            return this;
        }

        public final void setOrganizationConfigRuleName(String organizationConfigRuleName) {
            this.organizationConfigRuleName = organizationConfigRuleName;
        }

        public final String getOrganizationConfigRuleArn() {
            return this.organizationConfigRuleArn;
        }

        @Override
        public final Builder organizationConfigRuleArn(String organizationConfigRuleArn) {
            this.organizationConfigRuleArn = organizationConfigRuleArn;
            return this;
        }

        public final void setOrganizationConfigRuleArn(String organizationConfigRuleArn) {
            this.organizationConfigRuleArn = organizationConfigRuleArn;
        }

        public final OrganizationManagedRuleMetadata.Builder getOrganizationManagedRuleMetadata() {
            return this.organizationManagedRuleMetadata != null ? this.organizationManagedRuleMetadata.toBuilder() : null;
        }

        @Override
        public final Builder organizationManagedRuleMetadata(OrganizationManagedRuleMetadata organizationManagedRuleMetadata) {
            this.organizationManagedRuleMetadata = organizationManagedRuleMetadata;
            return this;
        }

        public final void setOrganizationManagedRuleMetadata(OrganizationManagedRuleMetadata.BuilderImpl organizationManagedRuleMetadata) {
            this.organizationManagedRuleMetadata = organizationManagedRuleMetadata != null ? organizationManagedRuleMetadata.build() : null;
        }

        public final OrganizationCustomRuleMetadata.Builder getOrganizationCustomRuleMetadata() {
            return this.organizationCustomRuleMetadata != null ? this.organizationCustomRuleMetadata.toBuilder() : null;
        }

        @Override
        public final Builder organizationCustomRuleMetadata(OrganizationCustomRuleMetadata organizationCustomRuleMetadata) {
            this.organizationCustomRuleMetadata = organizationCustomRuleMetadata;
            return this;
        }

        public final void setOrganizationCustomRuleMetadata(OrganizationCustomRuleMetadata.BuilderImpl organizationCustomRuleMetadata) {
            this.organizationCustomRuleMetadata = organizationCustomRuleMetadata != null ? organizationCustomRuleMetadata.build() : null;
        }

        public final Collection<String> getExcludedAccounts() {
            if (this.excludedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludedAccounts;
        }

        @Override
        public final Builder excludedAccounts(Collection<String> excludedAccounts) {
            this.excludedAccounts = ExcludedAccountsCopier.copy(excludedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedAccounts(String ... excludedAccounts) {
            this.excludedAccounts(Arrays.asList(excludedAccounts));
            return this;
        }

        public final void setExcludedAccounts(Collection<String> excludedAccounts) {
            this.excludedAccounts = ExcludedAccountsCopier.copy(excludedAccounts);
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public OrganizationConfigRule build() {
            return new OrganizationConfigRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationConfigRule> {
        public Builder organizationConfigRuleName(String var1);

        public Builder organizationConfigRuleArn(String var1);

        public Builder organizationManagedRuleMetadata(OrganizationManagedRuleMetadata var1);

        default public Builder organizationManagedRuleMetadata(Consumer<OrganizationManagedRuleMetadata.Builder> organizationManagedRuleMetadata) {
            return this.organizationManagedRuleMetadata((OrganizationManagedRuleMetadata)((OrganizationManagedRuleMetadata.Builder)OrganizationManagedRuleMetadata.builder().applyMutation(organizationManagedRuleMetadata)).build());
        }

        public Builder organizationCustomRuleMetadata(OrganizationCustomRuleMetadata var1);

        default public Builder organizationCustomRuleMetadata(Consumer<OrganizationCustomRuleMetadata.Builder> organizationCustomRuleMetadata) {
            return this.organizationCustomRuleMetadata((OrganizationCustomRuleMetadata)((OrganizationCustomRuleMetadata.Builder)OrganizationCustomRuleMetadata.builder().applyMutation(organizationCustomRuleMetadata)).build());
        }

        public Builder excludedAccounts(Collection<String> var1);

        public Builder excludedAccounts(String ... var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

