/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAggregateConfigRuleComplianceSummaryResponse extends ConfigResponse
        implements
        ToCopyableBuilder<GetAggregateConfigRuleComplianceSummaryResponse.Builder, GetAggregateConfigRuleComplianceSummaryResponse> {
    private static final SdkField<String> GROUP_BY_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupByKey").getter(getter(GetAggregateConfigRuleComplianceSummaryResponse::groupByKey))
            .setter(setter(Builder::groupByKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByKey").build()).build();

    private static final SdkField<List<AggregateComplianceCount>> AGGREGATE_COMPLIANCE_COUNTS_FIELD = SdkField
            .<List<AggregateComplianceCount>> builder(MarshallingType.LIST)
            .memberName("AggregateComplianceCounts")
            .getter(getter(GetAggregateConfigRuleComplianceSummaryResponse::aggregateComplianceCounts))
            .setter(setter(Builder::aggregateComplianceCounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregateComplianceCounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregateComplianceCount> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregateComplianceCount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetAggregateConfigRuleComplianceSummaryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_BY_KEY_FIELD,
            AGGREGATE_COMPLIANCE_COUNTS_FIELD, NEXT_TOKEN_FIELD));

    private final String groupByKey;

    private final List<AggregateComplianceCount> aggregateComplianceCounts;

    private final String nextToken;

    private GetAggregateConfigRuleComplianceSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.groupByKey = builder.groupByKey;
        this.aggregateComplianceCounts = builder.aggregateComplianceCounts;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Groups the result based on ACCOUNT_ID or AWS_REGION.
     * </p>
     * 
     * @return Groups the result based on ACCOUNT_ID or AWS_REGION.
     */
    public final String groupByKey() {
        return groupByKey;
    }

    /**
     * Returns true if the AggregateComplianceCounts property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAggregateComplianceCounts() {
        return aggregateComplianceCounts != null && !(aggregateComplianceCounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of AggregateComplianceCounts object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAggregateComplianceCounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns a list of AggregateComplianceCounts object.
     */
    public final List<AggregateComplianceCount> aggregateComplianceCounts() {
        return aggregateComplianceCounts;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupByKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregateComplianceCounts() ? aggregateComplianceCounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAggregateConfigRuleComplianceSummaryResponse)) {
            return false;
        }
        GetAggregateConfigRuleComplianceSummaryResponse other = (GetAggregateConfigRuleComplianceSummaryResponse) obj;
        return Objects.equals(groupByKey(), other.groupByKey())
                && hasAggregateComplianceCounts() == other.hasAggregateComplianceCounts()
                && Objects.equals(aggregateComplianceCounts(), other.aggregateComplianceCounts())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAggregateConfigRuleComplianceSummaryResponse").add("GroupByKey", groupByKey())
                .add("AggregateComplianceCounts", hasAggregateComplianceCounts() ? aggregateComplianceCounts() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupByKey":
            return Optional.ofNullable(clazz.cast(groupByKey()));
        case "AggregateComplianceCounts":
            return Optional.ofNullable(clazz.cast(aggregateComplianceCounts()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAggregateConfigRuleComplianceSummaryResponse, T> g) {
        return obj -> g.apply((GetAggregateConfigRuleComplianceSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAggregateConfigRuleComplianceSummaryResponse> {
        /**
         * <p>
         * Groups the result based on ACCOUNT_ID or AWS_REGION.
         * </p>
         * 
         * @param groupByKey
         *        Groups the result based on ACCOUNT_ID or AWS_REGION.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByKey(String groupByKey);

        /**
         * <p>
         * Returns a list of AggregateComplianceCounts object.
         * </p>
         * 
         * @param aggregateComplianceCounts
         *        Returns a list of AggregateComplianceCounts object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateComplianceCounts(Collection<AggregateComplianceCount> aggregateComplianceCounts);

        /**
         * <p>
         * Returns a list of AggregateComplianceCounts object.
         * </p>
         * 
         * @param aggregateComplianceCounts
         *        Returns a list of AggregateComplianceCounts object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateComplianceCounts(AggregateComplianceCount... aggregateComplianceCounts);

        /**
         * <p>
         * Returns a list of AggregateComplianceCounts object.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AggregateComplianceCount>.Builder} avoiding
         * the need to create one manually via {@link List<AggregateComplianceCount>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AggregateComplianceCount>.Builder#build()} is called
         * immediately and its result is passed to {@link #aggregateComplianceCounts(List<AggregateComplianceCount>)}.
         * 
         * @param aggregateComplianceCounts
         *        a consumer that will call methods on {@link List<AggregateComplianceCount>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregateComplianceCounts(List<AggregateComplianceCount>)
         */
        Builder aggregateComplianceCounts(Consumer<AggregateComplianceCount.Builder>... aggregateComplianceCounts);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private String groupByKey;

        private List<AggregateComplianceCount> aggregateComplianceCounts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAggregateConfigRuleComplianceSummaryResponse model) {
            super(model);
            groupByKey(model.groupByKey);
            aggregateComplianceCounts(model.aggregateComplianceCounts);
            nextToken(model.nextToken);
        }

        public final String getGroupByKey() {
            return groupByKey;
        }

        @Override
        public final Builder groupByKey(String groupByKey) {
            this.groupByKey = groupByKey;
            return this;
        }

        public final void setGroupByKey(String groupByKey) {
            this.groupByKey = groupByKey;
        }

        public final Collection<AggregateComplianceCount.Builder> getAggregateComplianceCounts() {
            if (aggregateComplianceCounts instanceof SdkAutoConstructList) {
                return null;
            }
            return aggregateComplianceCounts != null ? aggregateComplianceCounts.stream()
                    .map(AggregateComplianceCount::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder aggregateComplianceCounts(Collection<AggregateComplianceCount> aggregateComplianceCounts) {
            this.aggregateComplianceCounts = AggregateComplianceCountListCopier.copy(aggregateComplianceCounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateComplianceCounts(AggregateComplianceCount... aggregateComplianceCounts) {
            aggregateComplianceCounts(Arrays.asList(aggregateComplianceCounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateComplianceCounts(Consumer<AggregateComplianceCount.Builder>... aggregateComplianceCounts) {
            aggregateComplianceCounts(Stream.of(aggregateComplianceCounts)
                    .map(c -> AggregateComplianceCount.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAggregateComplianceCounts(Collection<AggregateComplianceCount.BuilderImpl> aggregateComplianceCounts) {
            this.aggregateComplianceCounts = AggregateComplianceCountListCopier.copyFromBuilder(aggregateComplianceCounts);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetAggregateConfigRuleComplianceSummaryResponse build() {
            return new GetAggregateConfigRuleComplianceSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
