/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.RemediationConfiguration;
import software.amazon.awssdk.services.config.model.RemediationConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailedRemediationBatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailedRemediationBatch> {
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(FailedRemediationBatch.getter(FailedRemediationBatch::failureMessage)).setter(FailedRemediationBatch.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final SdkField<List<RemediationConfiguration>> FAILED_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedItems").getter(FailedRemediationBatch.getter(FailedRemediationBatch::failedItems)).setter(FailedRemediationBatch.setter(Builder::failedItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemediationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_MESSAGE_FIELD, FAILED_ITEMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String failureMessage;
    private final List<RemediationConfiguration> failedItems;

    private FailedRemediationBatch(BuilderImpl builder) {
        this.failureMessage = builder.failureMessage;
        this.failedItems = builder.failedItems;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final boolean hasFailedItems() {
        return this.failedItems != null && !(this.failedItems instanceof SdkAutoConstructList);
    }

    public final List<RemediationConfiguration> failedItems() {
        return this.failedItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedItems() ? this.failedItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedRemediationBatch)) {
            return false;
        }
        FailedRemediationBatch other = (FailedRemediationBatch)obj;
        return Objects.equals(this.failureMessage(), other.failureMessage()) && this.hasFailedItems() == other.hasFailedItems() && Objects.equals(this.failedItems(), other.failedItems());
    }

    public final String toString() {
        return ToString.builder((String)"FailedRemediationBatch").add("FailureMessage", (Object)this.failureMessage()).add("FailedItems", this.hasFailedItems() ? this.failedItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "FailedItems": {
                return Optional.ofNullable(clazz.cast(this.failedItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailedRemediationBatch, T> g) {
        return obj -> g.apply((FailedRemediationBatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String failureMessage;
        private List<RemediationConfiguration> failedItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FailedRemediationBatch model) {
            this.failureMessage(model.failureMessage);
            this.failedItems(model.failedItems);
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        public final Collection<RemediationConfiguration.Builder> getFailedItems() {
            if (this.failedItems instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failedItems != null ? (Collection)this.failedItems.stream().map(RemediationConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedItems(Collection<RemediationConfiguration> failedItems) {
            this.failedItems = RemediationConfigurationsCopier.copy(failedItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedItems(RemediationConfiguration ... failedItems) {
            this.failedItems(Arrays.asList(failedItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedItems(Consumer<RemediationConfiguration.Builder> ... failedItems) {
            this.failedItems(Stream.of(failedItems).map(c -> (RemediationConfiguration)((RemediationConfiguration.Builder)RemediationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailedItems(Collection<RemediationConfiguration.BuilderImpl> failedItems) {
            this.failedItems = RemediationConfigurationsCopier.copyFromBuilder(failedItems);
        }

        public FailedRemediationBatch build() {
            return new FailedRemediationBatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailedRemediationBatch> {
        public Builder failureMessage(String var1);

        public Builder failedItems(Collection<RemediationConfiguration> var1);

        public Builder failedItems(RemediationConfiguration ... var1);

        public Builder failedItems(Consumer<RemediationConfiguration.Builder> ... var1);
    }
}

