/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.ConformancePackEvaluationResult;
import software.amazon.awssdk.services.config.model.ConformancePackRuleEvaluationResultsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConformancePackComplianceDetailsResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, GetConformancePackComplianceDetailsResponse> {
    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConformancePackName").getter(GetConformancePackComplianceDetailsResponse.getter(GetConformancePackComplianceDetailsResponse::conformancePackName)).setter(GetConformancePackComplianceDetailsResponse.setter(Builder::conformancePackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build()}).build();
    private static final SdkField<List<ConformancePackEvaluationResult>> CONFORMANCE_PACK_RULE_EVALUATION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConformancePackRuleEvaluationResults").getter(GetConformancePackComplianceDetailsResponse.getter(GetConformancePackComplianceDetailsResponse::conformancePackRuleEvaluationResults)).setter(GetConformancePackComplianceDetailsResponse.setter(Builder::conformancePackRuleEvaluationResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackRuleEvaluationResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConformancePackEvaluationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetConformancePackComplianceDetailsResponse.getter(GetConformancePackComplianceDetailsResponse::nextToken)).setter(GetConformancePackComplianceDetailsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_NAME_FIELD, CONFORMANCE_PACK_RULE_EVALUATION_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String conformancePackName;
    private final List<ConformancePackEvaluationResult> conformancePackRuleEvaluationResults;
    private final String nextToken;

    private GetConformancePackComplianceDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.conformancePackName = builder.conformancePackName;
        this.conformancePackRuleEvaluationResults = builder.conformancePackRuleEvaluationResults;
        this.nextToken = builder.nextToken;
    }

    public String conformancePackName() {
        return this.conformancePackName;
    }

    public boolean hasConformancePackRuleEvaluationResults() {
        return this.conformancePackRuleEvaluationResults != null && !(this.conformancePackRuleEvaluationResults instanceof SdkAutoConstructList);
    }

    public List<ConformancePackEvaluationResult> conformancePackRuleEvaluationResults() {
        return this.conformancePackRuleEvaluationResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConformancePackRuleEvaluationResults() ? this.conformancePackRuleEvaluationResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConformancePackComplianceDetailsResponse)) {
            return false;
        }
        GetConformancePackComplianceDetailsResponse other = (GetConformancePackComplianceDetailsResponse)((Object)obj);
        return Objects.equals(this.conformancePackName(), other.conformancePackName()) && this.hasConformancePackRuleEvaluationResults() == other.hasConformancePackRuleEvaluationResults() && Objects.equals(this.conformancePackRuleEvaluationResults(), other.conformancePackRuleEvaluationResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetConformancePackComplianceDetailsResponse").add("ConformancePackName", (Object)this.conformancePackName()).add("ConformancePackRuleEvaluationResults", this.hasConformancePackRuleEvaluationResults() ? this.conformancePackRuleEvaluationResults() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConformancePackName": {
                return Optional.ofNullable(clazz.cast(this.conformancePackName()));
            }
            case "ConformancePackRuleEvaluationResults": {
                return Optional.ofNullable(clazz.cast(this.conformancePackRuleEvaluationResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConformancePackComplianceDetailsResponse, T> g) {
        return obj -> g.apply((GetConformancePackComplianceDetailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private String conformancePackName;
        private List<ConformancePackEvaluationResult> conformancePackRuleEvaluationResults = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConformancePackComplianceDetailsResponse model) {
            super(model);
            this.conformancePackName(model.conformancePackName);
            this.conformancePackRuleEvaluationResults(model.conformancePackRuleEvaluationResults);
            this.nextToken(model.nextToken);
        }

        public final String getConformancePackName() {
            return this.conformancePackName;
        }

        @Override
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        public final Collection<ConformancePackEvaluationResult.Builder> getConformancePackRuleEvaluationResults() {
            if (this.conformancePackRuleEvaluationResults instanceof SdkAutoConstructList) {
                return null;
            }
            return this.conformancePackRuleEvaluationResults != null ? (Collection)this.conformancePackRuleEvaluationResults.stream().map(ConformancePackEvaluationResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conformancePackRuleEvaluationResults(Collection<ConformancePackEvaluationResult> conformancePackRuleEvaluationResults) {
            this.conformancePackRuleEvaluationResults = ConformancePackRuleEvaluationResultsListCopier.copy(conformancePackRuleEvaluationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackRuleEvaluationResults(ConformancePackEvaluationResult ... conformancePackRuleEvaluationResults) {
            this.conformancePackRuleEvaluationResults(Arrays.asList(conformancePackRuleEvaluationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackRuleEvaluationResults(Consumer<ConformancePackEvaluationResult.Builder> ... conformancePackRuleEvaluationResults) {
            this.conformancePackRuleEvaluationResults(Stream.of(conformancePackRuleEvaluationResults).map(c -> (ConformancePackEvaluationResult)((ConformancePackEvaluationResult.Builder)ConformancePackEvaluationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConformancePackRuleEvaluationResults(Collection<ConformancePackEvaluationResult.BuilderImpl> conformancePackRuleEvaluationResults) {
            this.conformancePackRuleEvaluationResults = ConformancePackRuleEvaluationResultsListCopier.copyFromBuilder(conformancePackRuleEvaluationResults);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetConformancePackComplianceDetailsResponse build() {
            return new GetConformancePackComplianceDetailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConformancePackComplianceDetailsResponse> {
        public Builder conformancePackName(String var1);

        public Builder conformancePackRuleEvaluationResults(Collection<ConformancePackEvaluationResult> var1);

        public Builder conformancePackRuleEvaluationResults(ConformancePackEvaluationResult ... var1);

        public Builder conformancePackRuleEvaluationResults(Consumer<ConformancePackEvaluationResult.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

