/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ResourceKey;
import software.amazon.awssdk.services.config.model.ResourceKeysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartRemediationExecutionRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, StartRemediationExecutionRequest> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigRuleName").getter(StartRemediationExecutionRequest.getter(StartRemediationExecutionRequest::configRuleName)).setter(StartRemediationExecutionRequest.setter(Builder::configRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()}).build();
    private static final SdkField<List<ResourceKey>> RESOURCE_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceKeys").getter(StartRemediationExecutionRequest.getter(StartRemediationExecutionRequest::resourceKeys)).setter(StartRemediationExecutionRequest.setter(Builder::resourceKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD, RESOURCE_KEYS_FIELD));
    private final String configRuleName;
    private final List<ResourceKey> resourceKeys;

    private StartRemediationExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.configRuleName = builder.configRuleName;
        this.resourceKeys = builder.resourceKeys;
    }

    public String configRuleName() {
        return this.configRuleName;
    }

    public boolean hasResourceKeys() {
        return this.resourceKeys != null && !(this.resourceKeys instanceof SdkAutoConstructList);
    }

    public List<ResourceKey> resourceKeys() {
        return this.resourceKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceKeys());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRemediationExecutionRequest)) {
            return false;
        }
        StartRemediationExecutionRequest other = (StartRemediationExecutionRequest)((Object)obj);
        return Objects.equals(this.configRuleName(), other.configRuleName()) && Objects.equals(this.resourceKeys(), other.resourceKeys());
    }

    public String toString() {
        return ToString.builder((String)"StartRemediationExecutionRequest").add("ConfigRuleName", (Object)this.configRuleName()).add("ResourceKeys", this.resourceKeys()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.configRuleName()));
            }
            case "ResourceKeys": {
                return Optional.ofNullable(clazz.cast(this.resourceKeys()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartRemediationExecutionRequest, T> g) {
        return obj -> g.apply((StartRemediationExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String configRuleName;
        private List<ResourceKey> resourceKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartRemediationExecutionRequest model) {
            super(model);
            this.configRuleName(model.configRuleName);
            this.resourceKeys(model.resourceKeys);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final Collection<ResourceKey.Builder> getResourceKeys() {
            return this.resourceKeys != null ? (Collection)this.resourceKeys.stream().map(ResourceKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceKeys(Collection<ResourceKey> resourceKeys) {
            this.resourceKeys = ResourceKeysCopier.copy(resourceKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceKeys(ResourceKey ... resourceKeys) {
            this.resourceKeys(Arrays.asList(resourceKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceKeys(Consumer<ResourceKey.Builder> ... resourceKeys) {
            this.resourceKeys(Stream.of(resourceKeys).map(c -> (ResourceKey)((ResourceKey.Builder)ResourceKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceKeys(Collection<ResourceKey.BuilderImpl> resourceKeys) {
            this.resourceKeys = ResourceKeysCopier.copyFromBuilder(resourceKeys);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartRemediationExecutionRequest build() {
            return new StartRemediationExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartRemediationExecutionRequest> {
        public Builder configRuleName(String var1);

        public Builder resourceKeys(Collection<ResourceKey> var1);

        public Builder resourceKeys(ResourceKey ... var1);

        public Builder resourceKeys(Consumer<ResourceKey.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

