/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetResourceConfigRequest extends ConfigRequest implements
        ToCopyableBuilder<BatchGetResourceConfigRequest.Builder, BatchGetResourceConfigRequest> {
    private static final SdkField<List<ResourceKey>> RESOURCE_KEYS_FIELD = SdkField
            .<List<ResourceKey>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetResourceConfigRequest::resourceKeys))
            .setter(setter(Builder::resourceKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_KEYS_FIELD));

    private final List<ResourceKey> resourceKeys;

    private BatchGetResourceConfigRequest(BuilderImpl builder) {
        super(builder);
        this.resourceKeys = builder.resourceKeys;
    }

    /**
     * Returns true if the ResourceKeys property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResourceKeys() {
        return resourceKeys != null && !(resourceKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource keys to be processed with the current request. Each element in the list consists of the
     * resource type and resource ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of resource keys to be processed with the current request. Each element in the list consists of
     *         the resource type and resource ID.
     */
    public List<ResourceKey> resourceKeys() {
        return resourceKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceKeys());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetResourceConfigRequest)) {
            return false;
        }
        BatchGetResourceConfigRequest other = (BatchGetResourceConfigRequest) obj;
        return Objects.equals(resourceKeys(), other.resourceKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetResourceConfigRequest").add("ResourceKeys", resourceKeys()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceKeys":
            return Optional.ofNullable(clazz.cast(resourceKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetResourceConfigRequest, T> g) {
        return obj -> g.apply((BatchGetResourceConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetResourceConfigRequest> {
        /**
         * <p>
         * A list of resource keys to be processed with the current request. Each element in the list consists of the
         * resource type and resource ID.
         * </p>
         * 
         * @param resourceKeys
         *        A list of resource keys to be processed with the current request. Each element in the list consists of
         *        the resource type and resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceKeys(Collection<ResourceKey> resourceKeys);

        /**
         * <p>
         * A list of resource keys to be processed with the current request. Each element in the list consists of the
         * resource type and resource ID.
         * </p>
         * 
         * @param resourceKeys
         *        A list of resource keys to be processed with the current request. Each element in the list consists of
         *        the resource type and resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceKeys(ResourceKey... resourceKeys);

        /**
         * <p>
         * A list of resource keys to be processed with the current request. Each element in the list consists of the
         * resource type and resource ID.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceKey>.Builder} avoiding the need to
         * create one manually via {@link List<ResourceKey>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceKey>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceKeys(List<ResourceKey>)}.
         * 
         * @param resourceKeys
         *        a consumer that will call methods on {@link List<ResourceKey>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceKeys(List<ResourceKey>)
         */
        Builder resourceKeys(Consumer<ResourceKey.Builder>... resourceKeys);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private List<ResourceKey> resourceKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetResourceConfigRequest model) {
            super(model);
            resourceKeys(model.resourceKeys);
        }

        public final Collection<ResourceKey.Builder> getResourceKeys() {
            return resourceKeys != null ? resourceKeys.stream().map(ResourceKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceKeys(Collection<ResourceKey> resourceKeys) {
            this.resourceKeys = ResourceKeysCopier.copy(resourceKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceKeys(ResourceKey... resourceKeys) {
            resourceKeys(Arrays.asList(resourceKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceKeys(Consumer<ResourceKey.Builder>... resourceKeys) {
            resourceKeys(Stream.of(resourceKeys).map(c -> ResourceKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceKeys(Collection<ResourceKey.BuilderImpl> resourceKeys) {
            this.resourceKeys = ResourceKeysCopier.copyFromBuilder(resourceKeys);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetResourceConfigRequest build() {
            return new BatchGetResourceConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
