/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.services.config.transform.ResourceCountMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceCount
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceCount> {
    private final String resourceType;
    private final Long count;

    private ResourceCount(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.count = builder.count;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeString() {
        return this.resourceType;
    }

    public Long count() {
        return this.count;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceCount)) {
            return false;
        }
        ResourceCount other = (ResourceCount)obj;
        return Objects.equals(this.resourceTypeString(), other.resourceTypeString()) && Objects.equals(this.count(), other.count());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceTypeString() != null) {
            sb.append("ResourceType: ").append(this.resourceTypeString()).append(",");
        }
        if (this.count() != null) {
            sb.append("Count: ").append(this.count()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.of(clazz.cast(this.resourceTypeString()));
            }
            case "count": {
                return Optional.of(clazz.cast(this.count()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceCountMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private Long count;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceCount model) {
            this.resourceType(model.resourceType);
            this.count(model.count);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Long getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        public ResourceCount build() {
            return new ResourceCount(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceCount> {
        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder count(Long var1);
    }
}

