/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.DeliveryChannelNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDeliveryChannelStatusRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, DescribeDeliveryChannelStatusRequest> {
    private final List<String> deliveryChannelNames;

    private DescribeDeliveryChannelStatusRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryChannelNames = builder.deliveryChannelNames;
    }

    public List<String> deliveryChannelNames() {
        return this.deliveryChannelNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryChannelNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveryChannelStatusRequest)) {
            return false;
        }
        DescribeDeliveryChannelStatusRequest other = (DescribeDeliveryChannelStatusRequest)((Object)obj);
        return Objects.equals(this.deliveryChannelNames(), other.deliveryChannelNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deliveryChannelNames() != null) {
            sb.append("DeliveryChannelNames: ").append(this.deliveryChannelNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryChannelNames": {
                return Optional.of(clazz.cast(this.deliveryChannelNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private List<String> deliveryChannelNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveryChannelStatusRequest model) {
            this.deliveryChannelNames(model.deliveryChannelNames);
        }

        public final Collection<String> getDeliveryChannelNames() {
            return this.deliveryChannelNames;
        }

        @Override
        public final Builder deliveryChannelNames(Collection<String> deliveryChannelNames) {
            this.deliveryChannelNames = DeliveryChannelNameListCopier.copy(deliveryChannelNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryChannelNames(String ... deliveryChannelNames) {
            this.deliveryChannelNames(Arrays.asList(deliveryChannelNames));
            return this;
        }

        public final void setDeliveryChannelNames(Collection<String> deliveryChannelNames) {
            this.deliveryChannelNames = DeliveryChannelNameListCopier.copy(deliveryChannelNames);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeDeliveryChannelStatusRequest build() {
            return new DescribeDeliveryChannelStatusRequest(this);
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    CopyableBuilder<Builder, DescribeDeliveryChannelStatusRequest> {
        public Builder deliveryChannelNames(Collection<String> var1);

        public Builder deliveryChannelNames(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

