/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.config.model.ComplianceByResource;
import software.amazon.awssdk.services.config.model.ComplianceByResourcesCopier;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeComplianceByResourceResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeComplianceByResourceResponse> {
    private final List<ComplianceByResource> complianceByResources;
    private final String nextToken;

    private DescribeComplianceByResourceResponse(BuilderImpl builder) {
        super(builder);
        this.complianceByResources = builder.complianceByResources;
        this.nextToken = builder.nextToken;
    }

    public List<ComplianceByResource> complianceByResources() {
        return this.complianceByResources;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceByResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComplianceByResourceResponse)) {
            return false;
        }
        DescribeComplianceByResourceResponse other = (DescribeComplianceByResourceResponse)((Object)obj);
        return Objects.equals(this.complianceByResources(), other.complianceByResources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.complianceByResources() != null) {
            sb.append("ComplianceByResources: ").append(this.complianceByResources()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceByResources": {
                return Optional.of(clazz.cast(this.complianceByResources()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<ComplianceByResource> complianceByResources;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComplianceByResourceResponse model) {
            this.complianceByResources(model.complianceByResources);
            this.nextToken(model.nextToken);
        }

        public final Collection<ComplianceByResource.Builder> getComplianceByResources() {
            return this.complianceByResources != null ? (Collection)this.complianceByResources.stream().map(ComplianceByResource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder complianceByResources(Collection<ComplianceByResource> complianceByResources) {
            this.complianceByResources = ComplianceByResourcesCopier.copy(complianceByResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceByResources(ComplianceByResource ... complianceByResources) {
            this.complianceByResources(Arrays.asList(complianceByResources));
            return this;
        }

        public final void setComplianceByResources(Collection<ComplianceByResource.BuilderImpl> complianceByResources) {
            this.complianceByResources = ComplianceByResourcesCopier.copyFromBuilder(complianceByResources);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeComplianceByResourceResponse build() {
            return new DescribeComplianceByResourceResponse(this);
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    CopyableBuilder<Builder, DescribeComplianceByResourceResponse> {
        public Builder complianceByResources(Collection<ComplianceByResource> var1);

        public Builder complianceByResources(ComplianceByResource ... var1);

        public Builder nextToken(String var1);
    }
}

