/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.services.config.model.ComplianceTypesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetComplianceDetailsByConfigRuleRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetComplianceDetailsByConfigRuleRequest> {
    private final String configRuleName;
    private final List<String> complianceTypes;
    private final Integer limit;
    private final String nextToken;

    private GetComplianceDetailsByConfigRuleRequest(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.complianceTypes = builder.complianceTypes;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public String configRuleName() {
        return this.configRuleName;
    }

    public List<ComplianceType> complianceTypes() {
        return TypeConverter.convert(this.complianceTypes, ComplianceType::fromValue);
    }

    public List<String> complianceTypesStrings() {
        return this.complianceTypes;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceTypesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceDetailsByConfigRuleRequest)) {
            return false;
        }
        GetComplianceDetailsByConfigRuleRequest other = (GetComplianceDetailsByConfigRuleRequest)((Object)obj);
        return Objects.equals(this.configRuleName(), other.configRuleName()) && Objects.equals(this.complianceTypesStrings(), other.complianceTypesStrings()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.configRuleName() != null) {
            sb.append("ConfigRuleName: ").append(this.configRuleName()).append(",");
        }
        if (this.complianceTypesStrings() != null) {
            sb.append("ComplianceTypes: ").append(this.complianceTypesStrings()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.of(clazz.cast(this.configRuleName()));
            }
            case "ComplianceTypes": {
                return Optional.of(clazz.cast(this.complianceTypesStrings()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String configRuleName;
        private List<String> complianceTypes;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceDetailsByConfigRuleRequest model) {
            this.configRuleName(model.configRuleName);
            this.complianceTypes(model.complianceTypes);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final Collection<String> getComplianceTypes() {
            return this.complianceTypes;
        }

        @Override
        public final Builder complianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypes(String ... complianceTypes) {
            this.complianceTypes(Arrays.asList(complianceTypes));
            return this;
        }

        public final void setComplianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public GetComplianceDetailsByConfigRuleRequest build() {
            return new GetComplianceDetailsByConfigRuleRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetComplianceDetailsByConfigRuleRequest> {
        public Builder configRuleName(String var1);

        public Builder complianceTypes(Collection<String> var1);

        public Builder complianceTypes(String ... var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);
    }
}

