/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.config.model.Source;
import software.amazon.awssdk.services.config.transform.SourceDetailUnmarshaller;

public class SourceUnmarshaller
implements Unmarshaller<Source, JsonUnmarshallerContext> {
    private static final SourceUnmarshaller INSTANCE = new SourceUnmarshaller();

    public Source unmarshall(JsonUnmarshallerContext context) throws Exception {
        Source.Builder sourceBuilder = Source.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Owner", targetDepth)) {
                    context.nextToken();
                    sourceBuilder.owner((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SourceIdentifier", targetDepth)) {
                    context.nextToken();
                    sourceBuilder.sourceIdentifier((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SourceDetails", targetDepth)) {
                    context.nextToken();
                    sourceBuilder.sourceDetails(new ListUnmarshaller((Unmarshaller)SourceDetailUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Source)sourceBuilder.build();
    }

    public static SourceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

