/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.Evaluation;

@SdkInternalApi
public class EvaluationMarshaller {
    private static final MarshallingInfo<String> COMPLIANCERESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceResourceType").build();
    private static final MarshallingInfo<String> COMPLIANCERESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceResourceId").build();
    private static final MarshallingInfo<String> COMPLIANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceType").build();
    private static final MarshallingInfo<String> ANNOTATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Annotation").build();
    private static final MarshallingInfo<Instant> ORDERINGTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrderingTimestamp").build();
    private static final EvaluationMarshaller instance = new EvaluationMarshaller();

    public static EvaluationMarshaller getInstance() {
        return instance;
    }

    public void marshall(Evaluation evaluation, ProtocolMarshaller protocolMarshaller) {
        if (evaluation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)evaluation.complianceResourceType(), COMPLIANCERESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)evaluation.complianceResourceId(), COMPLIANCERESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)evaluation.complianceType(), COMPLIANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)evaluation.annotation(), ANNOTATION_BINDING);
            protocolMarshaller.marshall((Object)evaluation.orderingTimestamp(), ORDERINGTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

