/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.services.config.model.ComplianceTypesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetComplianceDetailsByConfigRuleRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetComplianceDetailsByConfigRuleRequest> {
    private final String configRuleName;
    private final List<String> complianceTypes;
    private final Integer limit;
    private final String nextToken;

    private GetComplianceDetailsByConfigRuleRequest(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.complianceTypes = builder.complianceTypes;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public String configRuleName() {
        return this.configRuleName;
    }

    public List<String> complianceTypes() {
        return this.complianceTypes;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.configRuleName() == null ? 0 : this.configRuleName().hashCode());
        hashCode = 31 * hashCode + (this.complianceTypes() == null ? 0 : this.complianceTypes().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceDetailsByConfigRuleRequest)) {
            return false;
        }
        GetComplianceDetailsByConfigRuleRequest other = (GetComplianceDetailsByConfigRuleRequest)((Object)obj);
        if (other.configRuleName() == null ^ this.configRuleName() == null) {
            return false;
        }
        if (other.configRuleName() != null && !other.configRuleName().equals(this.configRuleName())) {
            return false;
        }
        if (other.complianceTypes() == null ^ this.complianceTypes() == null) {
            return false;
        }
        if (other.complianceTypes() != null && !other.complianceTypes().equals(this.complianceTypes())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configRuleName() != null) {
            sb.append("ConfigRuleName: ").append(this.configRuleName()).append(",");
        }
        if (this.complianceTypes() != null) {
            sb.append("ComplianceTypes: ").append(this.complianceTypes()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String configRuleName;
        private List<String> complianceTypes;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceDetailsByConfigRuleRequest model) {
            this.setConfigRuleName(model.configRuleName);
            this.setComplianceTypes(model.complianceTypes);
            this.setLimit(model.limit);
            this.setNextToken(model.nextToken);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final Collection<String> getComplianceTypes() {
            return this.complianceTypes;
        }

        @Override
        public final Builder complianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypes(String ... complianceTypes) {
            this.complianceTypes(Arrays.asList(complianceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypes(ComplianceType ... complianceTypes) {
            this.complianceTypes(Arrays.asList(complianceTypes).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setComplianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
        }

        @SafeVarargs
        public final void setComplianceTypes(String ... complianceTypes) {
            this.complianceTypes(Arrays.asList(complianceTypes));
        }

        @SafeVarargs
        public final void setComplianceTypes(ComplianceType ... complianceTypes) {
            this.complianceTypes(Arrays.asList(complianceTypes).stream().map(Object::toString).collect(Collectors.toList()));
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public GetComplianceDetailsByConfigRuleRequest build() {
            return new GetComplianceDetailsByConfigRuleRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetComplianceDetailsByConfigRuleRequest> {
        public Builder configRuleName(String var1);

        public Builder complianceTypes(Collection<String> var1);

        public Builder complianceTypes(String ... var1);

        public Builder complianceTypes(ComplianceType ... var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);
    }
}

