/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.RecorderStatus;
import software.amazon.awssdk.services.config.transform.ConfigurationRecorderStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfigurationRecorderStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, ConfigurationRecorderStatus> {
    private final String name;
    private final Instant lastStartTime;
    private final Instant lastStopTime;
    private final Boolean recording;
    private final String lastStatus;
    private final String lastErrorCode;
    private final String lastErrorMessage;
    private final Instant lastStatusChangeTime;

    private ConfigurationRecorderStatus(BuilderImpl builder) {
        this.name = builder.name;
        this.lastStartTime = builder.lastStartTime;
        this.lastStopTime = builder.lastStopTime;
        this.recording = builder.recording;
        this.lastStatus = builder.lastStatus;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.lastStatusChangeTime = builder.lastStatusChangeTime;
    }

    public String name() {
        return this.name;
    }

    public Instant lastStartTime() {
        return this.lastStartTime;
    }

    public Instant lastStopTime() {
        return this.lastStopTime;
    }

    public Boolean recording() {
        return this.recording;
    }

    public String lastStatus() {
        return this.lastStatus;
    }

    public String lastErrorCode() {
        return this.lastErrorCode;
    }

    public String lastErrorMessage() {
        return this.lastErrorMessage;
    }

    public Instant lastStatusChangeTime() {
        return this.lastStatusChangeTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.lastStartTime() == null ? 0 : this.lastStartTime().hashCode());
        hashCode = 31 * hashCode + (this.lastStopTime() == null ? 0 : this.lastStopTime().hashCode());
        hashCode = 31 * hashCode + (this.recording() == null ? 0 : this.recording().hashCode());
        hashCode = 31 * hashCode + (this.lastStatus() == null ? 0 : this.lastStatus().hashCode());
        hashCode = 31 * hashCode + (this.lastErrorCode() == null ? 0 : this.lastErrorCode().hashCode());
        hashCode = 31 * hashCode + (this.lastErrorMessage() == null ? 0 : this.lastErrorMessage().hashCode());
        hashCode = 31 * hashCode + (this.lastStatusChangeTime() == null ? 0 : this.lastStatusChangeTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRecorderStatus)) {
            return false;
        }
        ConfigurationRecorderStatus other = (ConfigurationRecorderStatus)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.lastStartTime() == null ^ this.lastStartTime() == null) {
            return false;
        }
        if (other.lastStartTime() != null && !other.lastStartTime().equals(this.lastStartTime())) {
            return false;
        }
        if (other.lastStopTime() == null ^ this.lastStopTime() == null) {
            return false;
        }
        if (other.lastStopTime() != null && !other.lastStopTime().equals(this.lastStopTime())) {
            return false;
        }
        if (other.recording() == null ^ this.recording() == null) {
            return false;
        }
        if (other.recording() != null && !other.recording().equals(this.recording())) {
            return false;
        }
        if (other.lastStatus() == null ^ this.lastStatus() == null) {
            return false;
        }
        if (other.lastStatus() != null && !other.lastStatus().equals(this.lastStatus())) {
            return false;
        }
        if (other.lastErrorCode() == null ^ this.lastErrorCode() == null) {
            return false;
        }
        if (other.lastErrorCode() != null && !other.lastErrorCode().equals(this.lastErrorCode())) {
            return false;
        }
        if (other.lastErrorMessage() == null ^ this.lastErrorMessage() == null) {
            return false;
        }
        if (other.lastErrorMessage() != null && !other.lastErrorMessage().equals(this.lastErrorMessage())) {
            return false;
        }
        if (other.lastStatusChangeTime() == null ^ this.lastStatusChangeTime() == null) {
            return false;
        }
        return other.lastStatusChangeTime() == null || other.lastStatusChangeTime().equals(this.lastStatusChangeTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.lastStartTime() != null) {
            sb.append("LastStartTime: ").append(this.lastStartTime()).append(",");
        }
        if (this.lastStopTime() != null) {
            sb.append("LastStopTime: ").append(this.lastStopTime()).append(",");
        }
        if (this.recording() != null) {
            sb.append("Recording: ").append(this.recording()).append(",");
        }
        if (this.lastStatus() != null) {
            sb.append("LastStatus: ").append(this.lastStatus()).append(",");
        }
        if (this.lastErrorCode() != null) {
            sb.append("LastErrorCode: ").append(this.lastErrorCode()).append(",");
        }
        if (this.lastErrorMessage() != null) {
            sb.append("LastErrorMessage: ").append(this.lastErrorMessage()).append(",");
        }
        if (this.lastStatusChangeTime() != null) {
            sb.append("LastStatusChangeTime: ").append(this.lastStatusChangeTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurationRecorderStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private Instant lastStartTime;
        private Instant lastStopTime;
        private Boolean recording;
        private String lastStatus;
        private String lastErrorCode;
        private String lastErrorMessage;
        private Instant lastStatusChangeTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRecorderStatus model) {
            this.setName(model.name);
            this.setLastStartTime(model.lastStartTime);
            this.setLastStopTime(model.lastStopTime);
            this.setRecording(model.recording);
            this.setLastStatus(model.lastStatus);
            this.setLastErrorCode(model.lastErrorCode);
            this.setLastErrorMessage(model.lastErrorMessage);
            this.setLastStatusChangeTime(model.lastStatusChangeTime);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getLastStartTime() {
            return this.lastStartTime;
        }

        @Override
        public final Builder lastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
            return this;
        }

        public final void setLastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
        }

        public final Instant getLastStopTime() {
            return this.lastStopTime;
        }

        @Override
        public final Builder lastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
            return this;
        }

        public final void setLastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
        }

        public final Boolean getRecording() {
            return this.recording;
        }

        @Override
        public final Builder recording(Boolean recording) {
            this.recording = recording;
            return this;
        }

        public final void setRecording(Boolean recording) {
            this.recording = recording;
        }

        public final String getLastStatus() {
            return this.lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(RecorderStatus lastStatus) {
            this.lastStatus(lastStatus.toString());
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final void setLastStatus(RecorderStatus lastStatus) {
            this.lastStatus(lastStatus.toString());
        }

        public final String getLastErrorCode() {
            return this.lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        public final String getLastErrorMessage() {
            return this.lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        public final Instant getLastStatusChangeTime() {
            return this.lastStatusChangeTime;
        }

        @Override
        public final Builder lastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
            return this;
        }

        public final void setLastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
        }

        public ConfigurationRecorderStatus build() {
            return new ConfigurationRecorderStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigurationRecorderStatus> {
        public Builder name(String var1);

        public Builder lastStartTime(Instant var1);

        public Builder lastStopTime(Instant var1);

        public Builder recording(Boolean var1);

        public Builder lastStatus(String var1);

        public Builder lastStatus(RecorderStatus var1);

        public Builder lastErrorCode(String var1);

        public Builder lastErrorMessage(String var1);

        public Builder lastStatusChangeTime(Instant var1);
    }
}

