/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ConfigRule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutConfigRuleRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, PutConfigRuleRequest> {
    private static final SdkField<ConfigRule> CONFIG_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutConfigRuleRequest.getter(PutConfigRuleRequest::configRule)).setter(PutConfigRuleRequest.setter(Builder::configRule)).constructor(ConfigRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_FIELD));
    private final ConfigRule configRule;

    private PutConfigRuleRequest(BuilderImpl builder) {
        super(builder);
        this.configRule = builder.configRule;
    }

    public ConfigRule configRule() {
        return this.configRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configRule());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigRuleRequest)) {
            return false;
        }
        PutConfigRuleRequest other = (PutConfigRuleRequest)((Object)obj);
        return Objects.equals(this.configRule(), other.configRule());
    }

    public String toString() {
        return ToString.builder((String)"PutConfigRuleRequest").add("ConfigRule", (Object)this.configRule()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRule": {
                return Optional.ofNullable(clazz.cast(this.configRule()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutConfigRuleRequest, T> g) {
        return obj -> g.apply((PutConfigRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private ConfigRule configRule;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigRuleRequest model) {
            super(model);
            this.configRule(model.configRule);
        }

        public final ConfigRule.Builder getConfigRule() {
            return this.configRule != null ? this.configRule.toBuilder() : null;
        }

        @Override
        public final Builder configRule(ConfigRule configRule) {
            this.configRule = configRule;
            return this;
        }

        public final void setConfigRule(ConfigRule.BuilderImpl configRule) {
            this.configRule = configRule != null ? configRule.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfigRuleRequest build() {
            return new PutConfigRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutConfigRuleRequest> {
        public Builder configRule(ConfigRule var1);

        default public Builder configRule(Consumer<ConfigRule.Builder> configRule) {
            return this.configRule((ConfigRule)((ConfigRule.Builder)ConfigRule.builder().applyMutation(configRule)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

