/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.PutEvaluationsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutEvaluationsRequestModelMarshaller {
    private static final MarshallingInfo<List> EVALUATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Evaluations").isBinary(false).build();
    private static final MarshallingInfo<String> RESULTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResultToken").isBinary(false).build();
    private static final MarshallingInfo<Boolean> TESTMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TestMode").isBinary(false).build();
    private static final PutEvaluationsRequestModelMarshaller INSTANCE = new PutEvaluationsRequestModelMarshaller();

    private PutEvaluationsRequestModelMarshaller() {
    }

    public static PutEvaluationsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutEvaluationsRequest putEvaluationsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)putEvaluationsRequest), (String)"putEvaluationsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(putEvaluationsRequest.evaluations(), EVALUATIONS_BINDING);
            protocolMarshaller.marshall((Object)putEvaluationsRequest.resultToken(), RESULTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)putEvaluationsRequest.testMode(), TESTMODE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

