/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.PendingAggregationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PendingAggregationRequestMarshaller {
    private static final MarshallingInfo<String> REQUESTERACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequesterAccountId").isBinary(false).build();
    private static final MarshallingInfo<String> REQUESTERAWSREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequesterAwsRegion").isBinary(false).build();
    private static final PendingAggregationRequestMarshaller INSTANCE = new PendingAggregationRequestMarshaller();

    private PendingAggregationRequestMarshaller() {
    }

    public static PendingAggregationRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PendingAggregationRequest pendingAggregationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)pendingAggregationRequest, (String)"pendingAggregationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)pendingAggregationRequest.requesterAccountId(), REQUESTERACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)pendingAggregationRequest.requesterAwsRegion(), REQUESTERAWSREGION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

