/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.OrganizationAggregationSource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OrganizationAggregationSourceMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").isBinary(false).build();
    private static final MarshallingInfo<List> AWSREGIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AwsRegions").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ALLAWSREGIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllAwsRegions").isBinary(false).build();
    private static final OrganizationAggregationSourceMarshaller INSTANCE = new OrganizationAggregationSourceMarshaller();

    private OrganizationAggregationSourceMarshaller() {
    }

    public static OrganizationAggregationSourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OrganizationAggregationSource organizationAggregationSource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)organizationAggregationSource, (String)"organizationAggregationSource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)organizationAggregationSource.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(organizationAggregationSource.awsRegions(), AWSREGIONS_BINDING);
            protocolMarshaller.marshall((Object)organizationAggregationSource.allAwsRegions(), ALLAWSREGIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

