/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.DeliveryChannel;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeliveryChannelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> S3BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3BucketName").isBinary(false).build();
    private static final MarshallingInfo<String> S3KEYPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3KeyPrefix").isBinary(false).build();
    private static final MarshallingInfo<String> SNSTOPICARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snsTopicARN").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CONFIGSNAPSHOTDELIVERYPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configSnapshotDeliveryProperties").isBinary(false).build();
    private static final DeliveryChannelMarshaller INSTANCE = new DeliveryChannelMarshaller();

    private DeliveryChannelMarshaller() {
    }

    public static DeliveryChannelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeliveryChannel deliveryChannel, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deliveryChannel, (String)"deliveryChannel");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deliveryChannel.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)deliveryChannel.s3BucketName(), S3BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)deliveryChannel.s3KeyPrefix(), S3KEYPREFIX_BINDING);
            protocolMarshaller.marshall((Object)deliveryChannel.snsTopicARN(), SNSTOPICARN_BINDING);
            protocolMarshaller.marshall((Object)deliveryChannel.configSnapshotDeliveryProperties(), CONFIGSNAPSHOTDELIVERYPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

