/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.AggregationAuthorization;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AggregationAuthorizationMarshaller {
    private static final MarshallingInfo<String> AGGREGATIONAUTHORIZATIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AggregationAuthorizationArn").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHORIZEDACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthorizedAccountId").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHORIZEDAWSREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthorizedAwsRegion").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final AggregationAuthorizationMarshaller INSTANCE = new AggregationAuthorizationMarshaller();

    private AggregationAuthorizationMarshaller() {
    }

    public static AggregationAuthorizationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AggregationAuthorization aggregationAuthorization, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)aggregationAuthorization, (String)"aggregationAuthorization");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)aggregationAuthorization.aggregationAuthorizationArn(), AGGREGATIONAUTHORIZATIONARN_BINDING);
            protocolMarshaller.marshall((Object)aggregationAuthorization.authorizedAccountId(), AUTHORIZEDACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)aggregationAuthorization.authorizedAwsRegion(), AUTHORIZEDAWSREGION_BINDING);
            protocolMarshaller.marshall((Object)aggregationAuthorization.creationTime(), CREATIONTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

