/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.Evaluation;
import software.amazon.awssdk.services.config.model.EvaluationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEvaluationsRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, PutEvaluationsRequest> {
    private final List<Evaluation> evaluations;
    private final String resultToken;
    private final Boolean testMode;

    private PutEvaluationsRequest(BuilderImpl builder) {
        super(builder);
        this.evaluations = builder.evaluations;
        this.resultToken = builder.resultToken;
        this.testMode = builder.testMode;
    }

    public List<Evaluation> evaluations() {
        return this.evaluations;
    }

    public String resultToken() {
        return this.resultToken;
    }

    public Boolean testMode() {
        return this.testMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluations());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.testMode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEvaluationsRequest)) {
            return false;
        }
        PutEvaluationsRequest other = (PutEvaluationsRequest)((Object)obj);
        return Objects.equals(this.evaluations(), other.evaluations()) && Objects.equals(this.resultToken(), other.resultToken()) && Objects.equals(this.testMode(), other.testMode());
    }

    public String toString() {
        return ToString.builder((String)"PutEvaluationsRequest").add("Evaluations", this.evaluations()).add("ResultToken", (Object)this.resultToken()).add("TestMode", (Object)this.testMode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Evaluations": {
                return Optional.ofNullable(clazz.cast(this.evaluations()));
            }
            case "ResultToken": {
                return Optional.ofNullable(clazz.cast(this.resultToken()));
            }
            case "TestMode": {
                return Optional.ofNullable(clazz.cast(this.testMode()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private List<Evaluation> evaluations = DefaultSdkAutoConstructList.getInstance();
        private String resultToken;
        private Boolean testMode;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEvaluationsRequest model) {
            super(model);
            this.evaluations(model.evaluations);
            this.resultToken(model.resultToken);
            this.testMode(model.testMode);
        }

        public final Collection<Evaluation.Builder> getEvaluations() {
            return this.evaluations != null ? (Collection)this.evaluations.stream().map(Evaluation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder evaluations(Collection<Evaluation> evaluations) {
            this.evaluations = EvaluationsCopier.copy(evaluations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluations(Evaluation ... evaluations) {
            this.evaluations(Arrays.asList(evaluations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluations(Consumer<Evaluation.Builder> ... evaluations) {
            this.evaluations(Stream.of(evaluations).map(c -> (Evaluation)((Evaluation.Builder)Evaluation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvaluations(Collection<Evaluation.BuilderImpl> evaluations) {
            this.evaluations = EvaluationsCopier.copyFromBuilder(evaluations);
        }

        public final String getResultToken() {
            return this.resultToken;
        }

        @Override
        public final Builder resultToken(String resultToken) {
            this.resultToken = resultToken;
            return this;
        }

        public final void setResultToken(String resultToken) {
            this.resultToken = resultToken;
        }

        public final Boolean getTestMode() {
            return this.testMode;
        }

        @Override
        public final Builder testMode(Boolean testMode) {
            this.testMode = testMode;
            return this;
        }

        public final void setTestMode(Boolean testMode) {
            this.testMode = testMode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEvaluationsRequest build() {
            return new PutEvaluationsRequest(this);
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    CopyableBuilder<Builder, PutEvaluationsRequest> {
        public Builder evaluations(Collection<Evaluation> var1);

        public Builder evaluations(Evaluation ... var1);

        public Builder evaluations(Consumer<Evaluation.Builder> ... var1);

        public Builder resultToken(String var1);

        public Builder testMode(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

