/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAggregationAuthorizationRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, PutAggregationAuthorizationRequest> {
    private final String authorizedAccountId;
    private final String authorizedAwsRegion;

    private PutAggregationAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.authorizedAccountId = builder.authorizedAccountId;
        this.authorizedAwsRegion = builder.authorizedAwsRegion;
    }

    public String authorizedAccountId() {
        return this.authorizedAccountId;
    }

    public String authorizedAwsRegion() {
        return this.authorizedAwsRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizedAwsRegion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAggregationAuthorizationRequest)) {
            return false;
        }
        PutAggregationAuthorizationRequest other = (PutAggregationAuthorizationRequest)((Object)obj);
        return Objects.equals(this.authorizedAccountId(), other.authorizedAccountId()) && Objects.equals(this.authorizedAwsRegion(), other.authorizedAwsRegion());
    }

    public String toString() {
        return ToString.builder((String)"PutAggregationAuthorizationRequest").add("AuthorizedAccountId", (Object)this.authorizedAccountId()).add("AuthorizedAwsRegion", (Object)this.authorizedAwsRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthorizedAccountId": {
                return Optional.ofNullable(clazz.cast(this.authorizedAccountId()));
            }
            case "AuthorizedAwsRegion": {
                return Optional.ofNullable(clazz.cast(this.authorizedAwsRegion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String authorizedAccountId;
        private String authorizedAwsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAggregationAuthorizationRequest model) {
            super(model);
            this.authorizedAccountId(model.authorizedAccountId);
            this.authorizedAwsRegion(model.authorizedAwsRegion);
        }

        public final String getAuthorizedAccountId() {
            return this.authorizedAccountId;
        }

        @Override
        public final Builder authorizedAccountId(String authorizedAccountId) {
            this.authorizedAccountId = authorizedAccountId;
            return this;
        }

        public final void setAuthorizedAccountId(String authorizedAccountId) {
            this.authorizedAccountId = authorizedAccountId;
        }

        public final String getAuthorizedAwsRegion() {
            return this.authorizedAwsRegion;
        }

        @Override
        public final Builder authorizedAwsRegion(String authorizedAwsRegion) {
            this.authorizedAwsRegion = authorizedAwsRegion;
            return this;
        }

        public final void setAuthorizedAwsRegion(String authorizedAwsRegion) {
            this.authorizedAwsRegion = authorizedAwsRegion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAggregationAuthorizationRequest build() {
            return new PutAggregationAuthorizationRequest(this);
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    CopyableBuilder<Builder, PutAggregationAuthorizationRequest> {
        public Builder authorizedAccountId(String var1);

        public Builder authorizedAwsRegion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

