/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AggregatedSourceStatusType;
import software.amazon.awssdk.services.config.model.AggregatedSourceStatusTypeListCopier;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationAggregatorSourcesStatusRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, DescribeConfigurationAggregatorSourcesStatusRequest> {
    private final String configurationAggregatorName;
    private final List<String> updateStatus;
    private final String nextToken;
    private final Integer limit;

    private DescribeConfigurationAggregatorSourcesStatusRequest(BuilderImpl builder) {
        super(builder);
        this.configurationAggregatorName = builder.configurationAggregatorName;
        this.updateStatus = builder.updateStatus;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    public String configurationAggregatorName() {
        return this.configurationAggregatorName;
    }

    public List<AggregatedSourceStatusType> updateStatus() {
        return TypeConverter.convert(this.updateStatus, AggregatedSourceStatusType::fromValue);
    }

    public List<String> updateStatusAsStrings() {
        return this.updateStatus;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationAggregatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateStatusAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationAggregatorSourcesStatusRequest)) {
            return false;
        }
        DescribeConfigurationAggregatorSourcesStatusRequest other = (DescribeConfigurationAggregatorSourcesStatusRequest)((Object)obj);
        return Objects.equals(this.configurationAggregatorName(), other.configurationAggregatorName()) && Objects.equals(this.updateStatusAsStrings(), other.updateStatusAsStrings()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.limit(), other.limit());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConfigurationAggregatorSourcesStatusRequest").add("ConfigurationAggregatorName", (Object)this.configurationAggregatorName()).add("UpdateStatus", this.updateStatusAsStrings()).add("NextToken", (Object)this.nextToken()).add("Limit", (Object)this.limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationAggregatorName": {
                return Optional.ofNullable(clazz.cast(this.configurationAggregatorName()));
            }
            case "UpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.updateStatusAsStrings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String configurationAggregatorName;
        private List<String> updateStatus = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationAggregatorSourcesStatusRequest model) {
            super(model);
            this.configurationAggregatorName(model.configurationAggregatorName);
            this.updateStatusWithStrings(model.updateStatus);
            this.nextToken(model.nextToken);
            this.limit(model.limit);
        }

        public final String getConfigurationAggregatorName() {
            return this.configurationAggregatorName;
        }

        @Override
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        public final Collection<String> getUpdateStatus() {
            return this.updateStatus;
        }

        @Override
        public final Builder updateStatusWithStrings(Collection<String> updateStatus) {
            this.updateStatus = AggregatedSourceStatusTypeListCopier.copy(updateStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateStatusWithStrings(String ... updateStatus) {
            this.updateStatusWithStrings(Arrays.asList(updateStatus));
            return this;
        }

        @Override
        public final Builder updateStatus(Collection<AggregatedSourceStatusType> updateStatus) {
            this.updateStatus = AggregatedSourceStatusTypeListCopier.copyEnumToString(updateStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateStatus(AggregatedSourceStatusType ... updateStatus) {
            this.updateStatus(Arrays.asList(updateStatus));
            return this;
        }

        public final void setUpdateStatus(Collection<String> updateStatus) {
            this.updateStatus = AggregatedSourceStatusTypeListCopier.copy(updateStatus);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationAggregatorSourcesStatusRequest build() {
            return new DescribeConfigurationAggregatorSourcesStatusRequest(this);
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    CopyableBuilder<Builder, DescribeConfigurationAggregatorSourcesStatusRequest> {
        public Builder configurationAggregatorName(String var1);

        public Builder updateStatusWithStrings(Collection<String> var1);

        public Builder updateStatusWithStrings(String ... var1);

        public Builder updateStatus(Collection<AggregatedSourceStatusType> var1);

        public Builder updateStatus(AggregatedSourceStatusType ... var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

