/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.Compliance;
import software.amazon.awssdk.services.config.transform.ComplianceByResourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComplianceByResource
implements StructuredPojo,
ToCopyableBuilder<Builder, ComplianceByResource> {
    private final String resourceType;
    private final String resourceId;
    private final Compliance compliance;

    private ComplianceByResource(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.compliance = builder.compliance;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public Compliance compliance() {
        return this.compliance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.compliance());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceByResource)) {
            return false;
        }
        ComplianceByResource other = (ComplianceByResource)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.compliance(), other.compliance());
    }

    public String toString() {
        return ToString.builder((String)"ComplianceByResource").add("ResourceType", (Object)this.resourceType()).add("ResourceId", (Object)this.resourceId()).add("Compliance", (Object)this.compliance()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "Compliance": {
                return Optional.ofNullable(clazz.cast(this.compliance()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceByResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String resourceId;
        private Compliance compliance;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceByResource model) {
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.compliance(model.compliance);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Compliance.Builder getCompliance() {
            return this.compliance != null ? this.compliance.toBuilder() : null;
        }

        @Override
        public final Builder compliance(Compliance compliance) {
            this.compliance = compliance;
            return this;
        }

        public final void setCompliance(Compliance.BuilderImpl compliance) {
            this.compliance = compliance != null ? compliance.build() : null;
        }

        public ComplianceByResource build() {
            return new ComplianceByResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComplianceByResource> {
        public Builder resourceType(String var1);

        public Builder resourceId(String var1);

        public Builder compliance(Compliance var1);

        default public Builder compliance(Consumer<Compliance.Builder> compliance) {
            return this.compliance((Compliance)((Compliance.Builder)Compliance.builder().applyMutation(compliance)).build());
        }
    }
}

