/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.BaseConfigurationItem;
import software.amazon.awssdk.services.config.model.BaseConfigurationItemsCopier;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.ResourceKey;
import software.amazon.awssdk.services.config.model.ResourceKeysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetResourceConfigResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, BatchGetResourceConfigResponse> {
    private final List<BaseConfigurationItem> baseConfigurationItems;
    private final List<ResourceKey> unprocessedResourceKeys;

    private BatchGetResourceConfigResponse(BuilderImpl builder) {
        super(builder);
        this.baseConfigurationItems = builder.baseConfigurationItems;
        this.unprocessedResourceKeys = builder.unprocessedResourceKeys;
    }

    public List<BaseConfigurationItem> baseConfigurationItems() {
        return this.baseConfigurationItems;
    }

    public List<ResourceKey> unprocessedResourceKeys() {
        return this.unprocessedResourceKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseConfigurationItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.unprocessedResourceKeys());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetResourceConfigResponse)) {
            return false;
        }
        BatchGetResourceConfigResponse other = (BatchGetResourceConfigResponse)((Object)obj);
        return Objects.equals(this.baseConfigurationItems(), other.baseConfigurationItems()) && Objects.equals(this.unprocessedResourceKeys(), other.unprocessedResourceKeys());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetResourceConfigResponse").add("BaseConfigurationItems", this.baseConfigurationItems()).add("UnprocessedResourceKeys", this.unprocessedResourceKeys()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "baseConfigurationItems": {
                return Optional.ofNullable(clazz.cast(this.baseConfigurationItems()));
            }
            case "unprocessedResourceKeys": {
                return Optional.ofNullable(clazz.cast(this.unprocessedResourceKeys()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<BaseConfigurationItem> baseConfigurationItems = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceKey> unprocessedResourceKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetResourceConfigResponse model) {
            super(model);
            this.baseConfigurationItems(model.baseConfigurationItems);
            this.unprocessedResourceKeys(model.unprocessedResourceKeys);
        }

        public final Collection<BaseConfigurationItem.Builder> getBaseConfigurationItems() {
            return this.baseConfigurationItems != null ? (Collection)this.baseConfigurationItems.stream().map(BaseConfigurationItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder baseConfigurationItems(Collection<BaseConfigurationItem> baseConfigurationItems) {
            this.baseConfigurationItems = BaseConfigurationItemsCopier.copy(baseConfigurationItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseConfigurationItems(BaseConfigurationItem ... baseConfigurationItems) {
            this.baseConfigurationItems(Arrays.asList(baseConfigurationItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseConfigurationItems(Consumer<BaseConfigurationItem.Builder> ... baseConfigurationItems) {
            this.baseConfigurationItems(Stream.of(baseConfigurationItems).map(c -> (BaseConfigurationItem)((BaseConfigurationItem.Builder)BaseConfigurationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBaseConfigurationItems(Collection<BaseConfigurationItem.BuilderImpl> baseConfigurationItems) {
            this.baseConfigurationItems = BaseConfigurationItemsCopier.copyFromBuilder(baseConfigurationItems);
        }

        public final Collection<ResourceKey.Builder> getUnprocessedResourceKeys() {
            return this.unprocessedResourceKeys != null ? (Collection)this.unprocessedResourceKeys.stream().map(ResourceKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedResourceKeys(Collection<ResourceKey> unprocessedResourceKeys) {
            this.unprocessedResourceKeys = ResourceKeysCopier.copy(unprocessedResourceKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedResourceKeys(ResourceKey ... unprocessedResourceKeys) {
            this.unprocessedResourceKeys(Arrays.asList(unprocessedResourceKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedResourceKeys(Consumer<ResourceKey.Builder> ... unprocessedResourceKeys) {
            this.unprocessedResourceKeys(Stream.of(unprocessedResourceKeys).map(c -> (ResourceKey)((ResourceKey.Builder)ResourceKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedResourceKeys(Collection<ResourceKey.BuilderImpl> unprocessedResourceKeys) {
            this.unprocessedResourceKeys = ResourceKeysCopier.copyFromBuilder(unprocessedResourceKeys);
        }

        @Override
        public BatchGetResourceConfigResponse build() {
            return new BatchGetResourceConfigResponse(this);
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    CopyableBuilder<Builder, BatchGetResourceConfigResponse> {
        public Builder baseConfigurationItems(Collection<BaseConfigurationItem> var1);

        public Builder baseConfigurationItems(BaseConfigurationItem ... var1);

        public Builder baseConfigurationItems(Consumer<BaseConfigurationItem.Builder> ... var1);

        public Builder unprocessedResourceKeys(Collection<ResourceKey> var1);

        public Builder unprocessedResourceKeys(ResourceKey ... var1);

        public Builder unprocessedResourceKeys(Consumer<ResourceKey.Builder> ... var1);
    }
}

