/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.config.model.ConfigurationItemStatus;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.services.config.model.SupplementaryConfigurationCopier;
import software.amazon.awssdk.services.config.transform.BaseConfigurationItemMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BaseConfigurationItem
implements StructuredPojo,
ToCopyableBuilder<Builder, BaseConfigurationItem> {
    private final String version;
    private final String accountId;
    private final Instant configurationItemCaptureTime;
    private final String configurationItemStatus;
    private final String configurationStateId;
    private final String arn;
    private final String resourceType;
    private final String resourceId;
    private final String resourceName;
    private final String awsRegion;
    private final String availabilityZone;
    private final Instant resourceCreationTime;
    private final String configuration;
    private final Map<String, String> supplementaryConfiguration;

    private BaseConfigurationItem(BuilderImpl builder) {
        this.version = builder.version;
        this.accountId = builder.accountId;
        this.configurationItemCaptureTime = builder.configurationItemCaptureTime;
        this.configurationItemStatus = builder.configurationItemStatus;
        this.configurationStateId = builder.configurationStateId;
        this.arn = builder.arn;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceName = builder.resourceName;
        this.awsRegion = builder.awsRegion;
        this.availabilityZone = builder.availabilityZone;
        this.resourceCreationTime = builder.resourceCreationTime;
        this.configuration = builder.configuration;
        this.supplementaryConfiguration = builder.supplementaryConfiguration;
    }

    public String version() {
        return this.version;
    }

    public String accountId() {
        return this.accountId;
    }

    public Instant configurationItemCaptureTime() {
        return this.configurationItemCaptureTime;
    }

    public ConfigurationItemStatus configurationItemStatus() {
        return ConfigurationItemStatus.fromValue(this.configurationItemStatus);
    }

    public String configurationItemStatusAsString() {
        return this.configurationItemStatus;
    }

    public String configurationStateId() {
        return this.configurationStateId;
    }

    public String arn() {
        return this.arn;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public String awsRegion() {
        return this.awsRegion;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Instant resourceCreationTime() {
        return this.resourceCreationTime;
    }

    public String configuration() {
        return this.configuration;
    }

    public Map<String, String> supplementaryConfiguration() {
        return this.supplementaryConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationItemCaptureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationItemStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationStateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.supplementaryConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseConfigurationItem)) {
            return false;
        }
        BaseConfigurationItem other = (BaseConfigurationItem)obj;
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.configurationItemCaptureTime(), other.configurationItemCaptureTime()) && Objects.equals(this.configurationItemStatusAsString(), other.configurationItemStatusAsString()) && Objects.equals(this.configurationStateId(), other.configurationStateId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.resourceCreationTime(), other.resourceCreationTime()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.supplementaryConfiguration(), other.supplementaryConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"BaseConfigurationItem").add("Version", (Object)this.version()).add("AccountId", (Object)this.accountId()).add("ConfigurationItemCaptureTime", (Object)this.configurationItemCaptureTime()).add("ConfigurationItemStatus", (Object)this.configurationItemStatusAsString()).add("ConfigurationStateId", (Object)this.configurationStateId()).add("Arn", (Object)this.arn()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceId", (Object)this.resourceId()).add("ResourceName", (Object)this.resourceName()).add("AwsRegion", (Object)this.awsRegion()).add("AvailabilityZone", (Object)this.availabilityZone()).add("ResourceCreationTime", (Object)this.resourceCreationTime()).add("Configuration", (Object)this.configuration()).add("SupplementaryConfiguration", this.supplementaryConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "configurationItemCaptureTime": {
                return Optional.ofNullable(clazz.cast(this.configurationItemCaptureTime()));
            }
            case "configurationItemStatus": {
                return Optional.ofNullable(clazz.cast(this.configurationItemStatusAsString()));
            }
            case "configurationStateId": {
                return Optional.ofNullable(clazz.cast(this.configurationStateId()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "resourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "awsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "resourceCreationTime": {
                return Optional.ofNullable(clazz.cast(this.resourceCreationTime()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "supplementaryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.supplementaryConfiguration()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BaseConfigurationItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private String accountId;
        private Instant configurationItemCaptureTime;
        private String configurationItemStatus;
        private String configurationStateId;
        private String arn;
        private String resourceType;
        private String resourceId;
        private String resourceName;
        private String awsRegion;
        private String availabilityZone;
        private Instant resourceCreationTime;
        private String configuration;
        private Map<String, String> supplementaryConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BaseConfigurationItem model) {
            this.version(model.version);
            this.accountId(model.accountId);
            this.configurationItemCaptureTime(model.configurationItemCaptureTime);
            this.configurationItemStatus(model.configurationItemStatus);
            this.configurationStateId(model.configurationStateId);
            this.arn(model.arn);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.resourceName(model.resourceName);
            this.awsRegion(model.awsRegion);
            this.availabilityZone(model.availabilityZone);
            this.resourceCreationTime(model.resourceCreationTime);
            this.configuration(model.configuration);
            this.supplementaryConfiguration(model.supplementaryConfiguration);
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Instant getConfigurationItemCaptureTime() {
            return this.configurationItemCaptureTime;
        }

        @Override
        public final Builder configurationItemCaptureTime(Instant configurationItemCaptureTime) {
            this.configurationItemCaptureTime = configurationItemCaptureTime;
            return this;
        }

        public final void setConfigurationItemCaptureTime(Instant configurationItemCaptureTime) {
            this.configurationItemCaptureTime = configurationItemCaptureTime;
        }

        public final String getConfigurationItemStatus() {
            return this.configurationItemStatus;
        }

        @Override
        public final Builder configurationItemStatus(String configurationItemStatus) {
            this.configurationItemStatus = configurationItemStatus;
            return this;
        }

        @Override
        public final Builder configurationItemStatus(ConfigurationItemStatus configurationItemStatus) {
            this.configurationItemStatus(configurationItemStatus.toString());
            return this;
        }

        public final void setConfigurationItemStatus(String configurationItemStatus) {
            this.configurationItemStatus = configurationItemStatus;
        }

        public final String getConfigurationStateId() {
            return this.configurationStateId;
        }

        @Override
        public final Builder configurationStateId(String configurationStateId) {
            this.configurationStateId = configurationStateId;
            return this;
        }

        public final void setConfigurationStateId(String configurationStateId) {
            this.configurationStateId = configurationStateId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Instant getResourceCreationTime() {
            return this.resourceCreationTime;
        }

        @Override
        public final Builder resourceCreationTime(Instant resourceCreationTime) {
            this.resourceCreationTime = resourceCreationTime;
            return this;
        }

        public final void setResourceCreationTime(Instant resourceCreationTime) {
            this.resourceCreationTime = resourceCreationTime;
        }

        public final String getConfiguration() {
            return this.configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        public final Map<String, String> getSupplementaryConfiguration() {
            return this.supplementaryConfiguration;
        }

        @Override
        public final Builder supplementaryConfiguration(Map<String, String> supplementaryConfiguration) {
            this.supplementaryConfiguration = SupplementaryConfigurationCopier.copy(supplementaryConfiguration);
            return this;
        }

        public final void setSupplementaryConfiguration(Map<String, String> supplementaryConfiguration) {
            this.supplementaryConfiguration = SupplementaryConfigurationCopier.copy(supplementaryConfiguration);
        }

        public BaseConfigurationItem build() {
            return new BaseConfigurationItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BaseConfigurationItem> {
        public Builder version(String var1);

        public Builder accountId(String var1);

        public Builder configurationItemCaptureTime(Instant var1);

        public Builder configurationItemStatus(String var1);

        public Builder configurationItemStatus(ConfigurationItemStatus var1);

        public Builder configurationStateId(String var1);

        public Builder arn(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceId(String var1);

        public Builder resourceName(String var1);

        public Builder awsRegion(String var1);

        public Builder availabilityZone(String var1);

        public Builder resourceCreationTime(Instant var1);

        public Builder configuration(String var1);

        public Builder supplementaryConfiguration(Map<String, String> var1);
    }
}

