/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.AggregationAuthorizationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregationAuthorization
implements StructuredPojo,
ToCopyableBuilder<Builder, AggregationAuthorization> {
    private final String aggregationAuthorizationArn;
    private final String authorizedAccountId;
    private final String authorizedAwsRegion;
    private final Instant creationTime;

    private AggregationAuthorization(BuilderImpl builder) {
        this.aggregationAuthorizationArn = builder.aggregationAuthorizationArn;
        this.authorizedAccountId = builder.authorizedAccountId;
        this.authorizedAwsRegion = builder.authorizedAwsRegion;
        this.creationTime = builder.creationTime;
    }

    public String aggregationAuthorizationArn() {
        return this.aggregationAuthorizationArn;
    }

    public String authorizedAccountId() {
        return this.authorizedAccountId;
    }

    public String authorizedAwsRegion() {
        return this.authorizedAwsRegion;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationAuthorizationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizedAwsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationAuthorization)) {
            return false;
        }
        AggregationAuthorization other = (AggregationAuthorization)obj;
        return Objects.equals(this.aggregationAuthorizationArn(), other.aggregationAuthorizationArn()) && Objects.equals(this.authorizedAccountId(), other.authorizedAccountId()) && Objects.equals(this.authorizedAwsRegion(), other.authorizedAwsRegion()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public String toString() {
        return ToString.builder((String)"AggregationAuthorization").add("AggregationAuthorizationArn", (Object)this.aggregationAuthorizationArn()).add("AuthorizedAccountId", (Object)this.authorizedAccountId()).add("AuthorizedAwsRegion", (Object)this.authorizedAwsRegion()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AggregationAuthorizationArn": {
                return Optional.ofNullable(clazz.cast(this.aggregationAuthorizationArn()));
            }
            case "AuthorizedAccountId": {
                return Optional.ofNullable(clazz.cast(this.authorizedAccountId()));
            }
            case "AuthorizedAwsRegion": {
                return Optional.ofNullable(clazz.cast(this.authorizedAwsRegion()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AggregationAuthorizationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String aggregationAuthorizationArn;
        private String authorizedAccountId;
        private String authorizedAwsRegion;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationAuthorization model) {
            this.aggregationAuthorizationArn(model.aggregationAuthorizationArn);
            this.authorizedAccountId(model.authorizedAccountId);
            this.authorizedAwsRegion(model.authorizedAwsRegion);
            this.creationTime(model.creationTime);
        }

        public final String getAggregationAuthorizationArn() {
            return this.aggregationAuthorizationArn;
        }

        @Override
        public final Builder aggregationAuthorizationArn(String aggregationAuthorizationArn) {
            this.aggregationAuthorizationArn = aggregationAuthorizationArn;
            return this;
        }

        public final void setAggregationAuthorizationArn(String aggregationAuthorizationArn) {
            this.aggregationAuthorizationArn = aggregationAuthorizationArn;
        }

        public final String getAuthorizedAccountId() {
            return this.authorizedAccountId;
        }

        @Override
        public final Builder authorizedAccountId(String authorizedAccountId) {
            this.authorizedAccountId = authorizedAccountId;
            return this;
        }

        public final void setAuthorizedAccountId(String authorizedAccountId) {
            this.authorizedAccountId = authorizedAccountId;
        }

        public final String getAuthorizedAwsRegion() {
            return this.authorizedAwsRegion;
        }

        @Override
        public final Builder authorizedAwsRegion(String authorizedAwsRegion) {
            this.authorizedAwsRegion = authorizedAwsRegion;
            return this;
        }

        public final void setAuthorizedAwsRegion(String authorizedAwsRegion) {
            this.authorizedAwsRegion = authorizedAwsRegion;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public AggregationAuthorization build() {
            return new AggregationAuthorization(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AggregationAuthorization> {
        public Builder aggregationAuthorizationArn(String var1);

        public Builder authorizedAccountId(String var1);

        public Builder authorizedAwsRegion(String var1);

        public Builder creationTime(Instant var1);
    }
}

