/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ComplianceSummary;
import software.amazon.awssdk.services.config.transform.AggregateComplianceCountMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregateComplianceCount
implements StructuredPojo,
ToCopyableBuilder<Builder, AggregateComplianceCount> {
    private final String groupName;
    private final ComplianceSummary complianceSummary;

    private AggregateComplianceCount(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.complianceSummary = builder.complianceSummary;
    }

    public String groupName() {
        return this.groupName;
    }

    public ComplianceSummary complianceSummary() {
        return this.complianceSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateComplianceCount)) {
            return false;
        }
        AggregateComplianceCount other = (AggregateComplianceCount)obj;
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.complianceSummary(), other.complianceSummary());
    }

    public String toString() {
        return ToString.builder((String)"AggregateComplianceCount").add("GroupName", (Object)this.groupName()).add("ComplianceSummary", (Object)this.complianceSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "ComplianceSummary": {
                return Optional.ofNullable(clazz.cast(this.complianceSummary()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AggregateComplianceCountMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupName;
        private ComplianceSummary complianceSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateComplianceCount model) {
            this.groupName(model.groupName);
            this.complianceSummary(model.complianceSummary);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final ComplianceSummary.Builder getComplianceSummary() {
            return this.complianceSummary != null ? this.complianceSummary.toBuilder() : null;
        }

        @Override
        public final Builder complianceSummary(ComplianceSummary complianceSummary) {
            this.complianceSummary = complianceSummary;
            return this;
        }

        public final void setComplianceSummary(ComplianceSummary.BuilderImpl complianceSummary) {
            this.complianceSummary = complianceSummary != null ? complianceSummary.build() : null;
        }

        public AggregateComplianceCount build() {
            return new AggregateComplianceCount(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AggregateComplianceCount> {
        public Builder groupName(String var1);

        public Builder complianceSummary(ComplianceSummary var1);

        default public Builder complianceSummary(Consumer<ComplianceSummary.Builder> complianceSummary) {
            return this.complianceSummary((ComplianceSummary)((ComplianceSummary.Builder)ComplianceSummary.builder().applyMutation(complianceSummary)).build());
        }
    }
}

