/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.EvaluationResult;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EvaluationResultMarshaller {
    private static final MarshallingInfo<StructuredPojo> EVALUATIONRESULTIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationResultIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> COMPLIANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceType").isBinary(false).build();
    private static final MarshallingInfo<Instant> RESULTRECORDEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResultRecordedTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> CONFIGRULEINVOKEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigRuleInvokedTime").isBinary(false).build();
    private static final MarshallingInfo<String> ANNOTATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Annotation").isBinary(false).build();
    private static final MarshallingInfo<String> RESULTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResultToken").isBinary(false).build();
    private static final EvaluationResultMarshaller INSTANCE = new EvaluationResultMarshaller();

    private EvaluationResultMarshaller() {
    }

    public static EvaluationResultMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EvaluationResult evaluationResult, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)evaluationResult, (String)"evaluationResult");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)evaluationResult.evaluationResultIdentifier(), EVALUATIONRESULTIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)evaluationResult.complianceTypeAsString(), COMPLIANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)evaluationResult.resultRecordedTime(), RESULTRECORDEDTIME_BINDING);
            protocolMarshaller.marshall((Object)evaluationResult.configRuleInvokedTime(), CONFIGRULEINVOKEDTIME_BINDING);
            protocolMarshaller.marshall((Object)evaluationResult.annotation(), ANNOTATION_BINDING);
            protocolMarshaller.marshall((Object)evaluationResult.resultToken(), RESULTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

