/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ConfigRule;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConfigRuleMarshaller {
    private static final MarshallingInfo<String> CONFIGRULENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigRuleName").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIGRULEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigRuleArn").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIGRULEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigRuleId").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SCOPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Scope").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Source").isBinary(false).build();
    private static final MarshallingInfo<String> INPUTPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputParameters").isBinary(false).build();
    private static final MarshallingInfo<String> MAXIMUMEXECUTIONFREQUENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaximumExecutionFrequency").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIGRULESTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigRuleState").isBinary(false).build();
    private static final ConfigRuleMarshaller INSTANCE = new ConfigRuleMarshaller();

    private ConfigRuleMarshaller() {
    }

    public static ConfigRuleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConfigRule configRule, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)configRule, (String)"configRule");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)configRule.configRuleName(), CONFIGRULENAME_BINDING);
            protocolMarshaller.marshall((Object)configRule.configRuleArn(), CONFIGRULEARN_BINDING);
            protocolMarshaller.marshall((Object)configRule.configRuleId(), CONFIGRULEID_BINDING);
            protocolMarshaller.marshall((Object)configRule.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)configRule.scope(), SCOPE_BINDING);
            protocolMarshaller.marshall((Object)configRule.source(), SOURCE_BINDING);
            protocolMarshaller.marshall((Object)configRule.inputParameters(), INPUTPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)configRule.maximumExecutionFrequencyAsString(), MAXIMUMEXECUTIONFREQUENCY_BINDING);
            protocolMarshaller.marshall((Object)configRule.configRuleStateAsString(), CONFIGRULESTATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

