/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.ConfigRuleEvaluationStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConfigRuleEvaluationStatusMarshaller {
    private static final MarshallingInfo<String> CONFIGRULENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigRuleName").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIGRULEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigRuleArn").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIGRULEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigRuleId").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTSUCCESSFULINVOCATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastSuccessfulInvocationTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTFAILEDINVOCATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastFailedInvocationTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTSUCCESSFULEVALUATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastSuccessfulEvaluationTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTFAILEDEVALUATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastFailedEvaluationTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> FIRSTACTIVATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FirstActivatedTime").isBinary(false).build();
    private static final MarshallingInfo<String> LASTERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastErrorCode").isBinary(false).build();
    private static final MarshallingInfo<String> LASTERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastErrorMessage").isBinary(false).build();
    private static final MarshallingInfo<Boolean> FIRSTEVALUATIONSTARTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FirstEvaluationStarted").isBinary(false).build();
    private static final ConfigRuleEvaluationStatusMarshaller INSTANCE = new ConfigRuleEvaluationStatusMarshaller();

    private ConfigRuleEvaluationStatusMarshaller() {
    }

    public static ConfigRuleEvaluationStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConfigRuleEvaluationStatus configRuleEvaluationStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)configRuleEvaluationStatus, (String)"configRuleEvaluationStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)configRuleEvaluationStatus.configRuleName(), CONFIGRULENAME_BINDING);
            protocolMarshaller.marshall((Object)configRuleEvaluationStatus.configRuleArn(), CONFIGRULEARN_BINDING);
            protocolMarshaller.marshall((Object)configRuleEvaluationStatus.configRuleId(), CONFIGRULEID_BINDING);
            protocolMarshaller.marshall((Object)configRuleEvaluationStatus.lastSuccessfulInvocationTime(), LASTSUCCESSFULINVOCATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)configRuleEvaluationStatus.lastFailedInvocationTime(), LASTFAILEDINVOCATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)configRuleEvaluationStatus.lastSuccessfulEvaluationTime(), LASTSUCCESSFULEVALUATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)configRuleEvaluationStatus.lastFailedEvaluationTime(), LASTFAILEDEVALUATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)configRuleEvaluationStatus.firstActivatedTime(), FIRSTACTIVATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)configRuleEvaluationStatus.lastErrorCode(), LASTERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)configRuleEvaluationStatus.lastErrorMessage(), LASTERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)configRuleEvaluationStatus.firstEvaluationStarted(), FIRSTEVALUATIONSTARTED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

