/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.ConfigExportDeliveryInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConfigExportDeliveryInfoMarshaller {
    private static final MarshallingInfo<String> LASTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStatus").isBinary(false).build();
    private static final MarshallingInfo<String> LASTERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastErrorCode").isBinary(false).build();
    private static final MarshallingInfo<String> LASTERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastErrorMessage").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTATTEMPTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastAttemptTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTSUCCESSFULTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastSuccessfulTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> NEXTDELIVERYTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextDeliveryTime").isBinary(false).build();
    private static final ConfigExportDeliveryInfoMarshaller INSTANCE = new ConfigExportDeliveryInfoMarshaller();

    private ConfigExportDeliveryInfoMarshaller() {
    }

    public static ConfigExportDeliveryInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConfigExportDeliveryInfo configExportDeliveryInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)configExportDeliveryInfo, (String)"configExportDeliveryInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)configExportDeliveryInfo.lastStatusAsString(), LASTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)configExportDeliveryInfo.lastErrorCode(), LASTERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)configExportDeliveryInfo.lastErrorMessage(), LASTERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)configExportDeliveryInfo.lastAttemptTime(), LASTATTEMPTTIME_BINDING);
            protocolMarshaller.marshall((Object)configExportDeliveryInfo.lastSuccessfulTime(), LASTSUCCESSFULTIME_BINDING);
            protocolMarshaller.marshall((Object)configExportDeliveryInfo.nextDeliveryTime(), NEXTDELIVERYTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

