/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.EventSource;
import software.amazon.awssdk.services.config.model.MaximumExecutionFrequency;
import software.amazon.awssdk.services.config.model.MessageType;
import software.amazon.awssdk.services.config.transform.SourceDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, SourceDetail> {
    private final String eventSource;
    private final String messageType;
    private final String maximumExecutionFrequency;

    private SourceDetail(BuilderImpl builder) {
        this.eventSource = builder.eventSource;
        this.messageType = builder.messageType;
        this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
    }

    public EventSource eventSource() {
        return EventSource.fromValue(this.eventSource);
    }

    public String eventSourceAsString() {
        return this.eventSource;
    }

    public MessageType messageType() {
        return MessageType.fromValue(this.messageType);
    }

    public String messageTypeAsString() {
        return this.messageType;
    }

    public MaximumExecutionFrequency maximumExecutionFrequency() {
        return MaximumExecutionFrequency.fromValue(this.maximumExecutionFrequency);
    }

    public String maximumExecutionFrequencyAsString() {
        return this.maximumExecutionFrequency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumExecutionFrequencyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDetail)) {
            return false;
        }
        SourceDetail other = (SourceDetail)obj;
        return Objects.equals(this.eventSourceAsString(), other.eventSourceAsString()) && Objects.equals(this.messageTypeAsString(), other.messageTypeAsString()) && Objects.equals(this.maximumExecutionFrequencyAsString(), other.maximumExecutionFrequencyAsString());
    }

    public String toString() {
        return ToString.builder((String)"SourceDetail").add("EventSource", (Object)this.eventSourceAsString()).add("MessageType", (Object)this.messageTypeAsString()).add("MaximumExecutionFrequency", (Object)this.maximumExecutionFrequencyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventSource": {
                return Optional.ofNullable(clazz.cast(this.eventSourceAsString()));
            }
            case "MessageType": {
                return Optional.ofNullable(clazz.cast(this.messageTypeAsString()));
            }
            case "MaximumExecutionFrequency": {
                return Optional.ofNullable(clazz.cast(this.maximumExecutionFrequencyAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventSource;
        private String messageType;
        private String maximumExecutionFrequency;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceDetail model) {
            this.eventSource(model.eventSource);
            this.messageType(model.messageType);
            this.maximumExecutionFrequency(model.maximumExecutionFrequency);
        }

        public final String getEventSource() {
            return this.eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        @Override
        public final Builder eventSource(EventSource eventSource) {
            this.eventSource(eventSource.toString());
            return this;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        public final String getMessageType() {
            return this.messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType.toString());
            return this;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        public final String getMaximumExecutionFrequency() {
            return this.maximumExecutionFrequency;
        }

        @Override
        public final Builder maximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        @Override
        public final Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency) {
            this.maximumExecutionFrequency(maximumExecutionFrequency.toString());
            return this;
        }

        public final void setMaximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
        }

        public SourceDetail build() {
            return new SourceDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SourceDetail> {
        public Builder eventSource(String var1);

        public Builder eventSource(EventSource var1);

        public Builder messageType(String var1);

        public Builder messageType(MessageType var1);

        public Builder maximumExecutionFrequency(String var1);

        public Builder maximumExecutionFrequency(MaximumExecutionFrequency var1);
    }
}

