/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.config.model.DeliveryChannel;
import software.amazon.awssdk.services.config.transform.ConfigSnapshotDeliveryPropertiesUnmarshaller;

public class DeliveryChannelUnmarshaller
implements Unmarshaller<DeliveryChannel, JsonUnmarshallerContext> {
    private static final DeliveryChannelUnmarshaller INSTANCE = new DeliveryChannelUnmarshaller();

    public DeliveryChannel unmarshall(JsonUnmarshallerContext context) throws Exception {
        DeliveryChannel.Builder deliveryChannelBuilder = DeliveryChannel.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    deliveryChannelBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("s3BucketName", targetDepth)) {
                    context.nextToken();
                    deliveryChannelBuilder.s3BucketName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("s3KeyPrefix", targetDepth)) {
                    context.nextToken();
                    deliveryChannelBuilder.s3KeyPrefix((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("snsTopicARN", targetDepth)) {
                    context.nextToken();
                    deliveryChannelBuilder.snsTopicARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("configSnapshotDeliveryProperties", targetDepth)) {
                    context.nextToken();
                    deliveryChannelBuilder.configSnapshotDeliveryProperties(ConfigSnapshotDeliveryPropertiesUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DeliveryChannel)deliveryChannelBuilder.build();
    }

    public static DeliveryChannelUnmarshaller getInstance() {
        return INSTANCE;
    }
}

