/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.ConfigurationRecorderStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConfigurationRecorderStatusMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStartTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTSTOPTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStopTime").isBinary(false).build();
    private static final MarshallingInfo<Boolean> RECORDING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recording").isBinary(false).build();
    private static final MarshallingInfo<String> LASTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStatus").isBinary(false).build();
    private static final MarshallingInfo<String> LASTERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastErrorCode").isBinary(false).build();
    private static final MarshallingInfo<String> LASTERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastErrorMessage").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTSTATUSCHANGETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStatusChangeTime").isBinary(false).build();
    private static final ConfigurationRecorderStatusMarshaller INSTANCE = new ConfigurationRecorderStatusMarshaller();

    private ConfigurationRecorderStatusMarshaller() {
    }

    public static ConfigurationRecorderStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConfigurationRecorderStatus configurationRecorderStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)configurationRecorderStatus, (String)"configurationRecorderStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)configurationRecorderStatus.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)configurationRecorderStatus.lastStartTime(), LASTSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)configurationRecorderStatus.lastStopTime(), LASTSTOPTIME_BINDING);
            protocolMarshaller.marshall((Object)configurationRecorderStatus.recording(), RECORDING_BINDING);
            protocolMarshaller.marshall((Object)configurationRecorderStatus.lastStatusAsString(), LASTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)configurationRecorderStatus.lastErrorCode(), LASTERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)configurationRecorderStatus.lastErrorMessage(), LASTERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)configurationRecorderStatus.lastStatusChangeTime(), LASTSTATUSCHANGETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

