/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.services.config.transform.ResourceIdentifierMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceIdentifier
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceIdentifier> {
    private final String resourceType;
    private final String resourceId;
    private final String resourceName;
    private final Instant resourceDeletionTime;

    private ResourceIdentifier(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceName = builder.resourceName;
        this.resourceDeletionTime = builder.resourceDeletionTime;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public Instant resourceDeletionTime() {
        return this.resourceDeletionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDeletionTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceIdentifier)) {
            return false;
        }
        ResourceIdentifier other = (ResourceIdentifier)obj;
        return Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.resourceDeletionTime(), other.resourceDeletionTime());
    }

    public String toString() {
        return ToString.builder((String)"ResourceIdentifier").add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceId", (Object)this.resourceId()).add("ResourceName", (Object)this.resourceName()).add("ResourceDeletionTime", (Object)this.resourceDeletionTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.of(clazz.cast(this.resourceTypeAsString()));
            }
            case "resourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
            case "resourceName": {
                return Optional.of(clazz.cast(this.resourceName()));
            }
            case "resourceDeletionTime": {
                return Optional.of(clazz.cast(this.resourceDeletionTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String resourceId;
        private String resourceName;
        private Instant resourceDeletionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceIdentifier model) {
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.resourceName(model.resourceName);
            this.resourceDeletionTime(model.resourceDeletionTime);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final Instant getResourceDeletionTime() {
            return this.resourceDeletionTime;
        }

        @Override
        public final Builder resourceDeletionTime(Instant resourceDeletionTime) {
            this.resourceDeletionTime = resourceDeletionTime;
            return this;
        }

        public final void setResourceDeletionTime(Instant resourceDeletionTime) {
            this.resourceDeletionTime = resourceDeletionTime;
        }

        public ResourceIdentifier build() {
            return new ResourceIdentifier(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceIdentifier> {
        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceId(String var1);

        public Builder resourceName(String var1);

        public Builder resourceDeletionTime(Instant var1);
    }
}

