/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.services.config.model.ResourceTypeListCopier;
import software.amazon.awssdk.services.config.transform.RecordingGroupMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RecordingGroup
implements StructuredPojo,
ToCopyableBuilder<Builder, RecordingGroup> {
    private final Boolean allSupported;
    private final Boolean includeGlobalResourceTypes;
    private final List<String> resourceTypes;

    private RecordingGroup(BuilderImpl builder) {
        this.allSupported = builder.allSupported;
        this.includeGlobalResourceTypes = builder.includeGlobalResourceTypes;
        this.resourceTypes = builder.resourceTypes;
    }

    public Boolean allSupported() {
        return this.allSupported;
    }

    public Boolean includeGlobalResourceTypes() {
        return this.includeGlobalResourceTypes;
    }

    public List<ResourceType> resourceTypes() {
        return TypeConverter.convert(this.resourceTypes, ResourceType::fromValue);
    }

    public List<String> resourceTypesAsStrings() {
        return this.resourceTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allSupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeGlobalResourceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordingGroup)) {
            return false;
        }
        RecordingGroup other = (RecordingGroup)obj;
        return Objects.equals(this.allSupported(), other.allSupported()) && Objects.equals(this.includeGlobalResourceTypes(), other.includeGlobalResourceTypes()) && Objects.equals(this.resourceTypesAsStrings(), other.resourceTypesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"RecordingGroup").add("AllSupported", (Object)this.allSupported()).add("IncludeGlobalResourceTypes", (Object)this.includeGlobalResourceTypes()).add("ResourceTypes", this.resourceTypesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allSupported": {
                return Optional.of(clazz.cast(this.allSupported()));
            }
            case "includeGlobalResourceTypes": {
                return Optional.of(clazz.cast(this.includeGlobalResourceTypes()));
            }
            case "resourceTypes": {
                return Optional.of(clazz.cast(this.resourceTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordingGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean allSupported;
        private Boolean includeGlobalResourceTypes;
        private List<String> resourceTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordingGroup model) {
            this.allSupported(model.allSupported);
            this.includeGlobalResourceTypes(model.includeGlobalResourceTypes);
            this.resourceTypes(model.resourceTypes);
        }

        public final Boolean getAllSupported() {
            return this.allSupported;
        }

        @Override
        public final Builder allSupported(Boolean allSupported) {
            this.allSupported = allSupported;
            return this;
        }

        public final void setAllSupported(Boolean allSupported) {
            this.allSupported = allSupported;
        }

        public final Boolean getIncludeGlobalResourceTypes() {
            return this.includeGlobalResourceTypes;
        }

        @Override
        public final Builder includeGlobalResourceTypes(Boolean includeGlobalResourceTypes) {
            this.includeGlobalResourceTypes = includeGlobalResourceTypes;
            return this;
        }

        public final void setIncludeGlobalResourceTypes(Boolean includeGlobalResourceTypes) {
            this.includeGlobalResourceTypes = includeGlobalResourceTypes;
        }

        public final Collection<String> getResourceTypes() {
            return this.resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copy(resourceTypes);
        }

        public RecordingGroup build() {
            return new RecordingGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RecordingGroup> {
        public Builder allSupported(Boolean var1);

        public Builder includeGlobalResourceTypes(Boolean var1);

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);
    }
}

