/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.DeliveryChannel;
import software.amazon.awssdk.services.config.model.DeliveryChannelListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDeliveryChannelsResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeDeliveryChannelsResponse> {
    private final List<DeliveryChannel> deliveryChannels;

    private DescribeDeliveryChannelsResponse(BuilderImpl builder) {
        super(builder);
        this.deliveryChannels = builder.deliveryChannels;
    }

    public List<DeliveryChannel> deliveryChannels() {
        return this.deliveryChannels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryChannels());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveryChannelsResponse)) {
            return false;
        }
        DescribeDeliveryChannelsResponse other = (DescribeDeliveryChannelsResponse)((Object)obj);
        return Objects.equals(this.deliveryChannels(), other.deliveryChannels());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDeliveryChannelsResponse").add("DeliveryChannels", this.deliveryChannels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryChannels": {
                return Optional.of(clazz.cast(this.deliveryChannels()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<DeliveryChannel> deliveryChannels;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveryChannelsResponse model) {
            super(model);
            this.deliveryChannels(model.deliveryChannels);
        }

        public final Collection<DeliveryChannel.Builder> getDeliveryChannels() {
            return this.deliveryChannels != null ? (Collection)this.deliveryChannels.stream().map(DeliveryChannel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deliveryChannels(Collection<DeliveryChannel> deliveryChannels) {
            this.deliveryChannels = DeliveryChannelListCopier.copy(deliveryChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryChannels(DeliveryChannel ... deliveryChannels) {
            this.deliveryChannels(Arrays.asList(deliveryChannels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryChannels(Consumer<DeliveryChannel.Builder> ... deliveryChannels) {
            this.deliveryChannels(Stream.of(deliveryChannels).map(c -> (DeliveryChannel)((DeliveryChannel.Builder)DeliveryChannel.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeliveryChannels(Collection<DeliveryChannel.BuilderImpl> deliveryChannels) {
            this.deliveryChannels = DeliveryChannelListCopier.copyFromBuilder(deliveryChannels);
        }

        @Override
        public DescribeDeliveryChannelsResponse build() {
            return new DescribeDeliveryChannelsResponse(this);
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    CopyableBuilder<Builder, DescribeDeliveryChannelsResponse> {
        public Builder deliveryChannels(Collection<DeliveryChannel> var1);

        public Builder deliveryChannels(DeliveryChannel ... var1);

        public Builder deliveryChannels(Consumer<DeliveryChannel.Builder> ... var1);
    }
}

