/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ComplianceContributorCount;
import software.amazon.awssdk.services.config.transform.ComplianceSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComplianceSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, ComplianceSummary> {
    private final ComplianceContributorCount compliantResourceCount;
    private final ComplianceContributorCount nonCompliantResourceCount;
    private final Instant complianceSummaryTimestamp;

    private ComplianceSummary(BuilderImpl builder) {
        this.compliantResourceCount = builder.compliantResourceCount;
        this.nonCompliantResourceCount = builder.nonCompliantResourceCount;
        this.complianceSummaryTimestamp = builder.complianceSummaryTimestamp;
    }

    public ComplianceContributorCount compliantResourceCount() {
        return this.compliantResourceCount;
    }

    public ComplianceContributorCount nonCompliantResourceCount() {
        return this.nonCompliantResourceCount;
    }

    public Instant complianceSummaryTimestamp() {
        return this.complianceSummaryTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.compliantResourceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonCompliantResourceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceSummaryTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceSummary)) {
            return false;
        }
        ComplianceSummary other = (ComplianceSummary)obj;
        return Objects.equals(this.compliantResourceCount(), other.compliantResourceCount()) && Objects.equals(this.nonCompliantResourceCount(), other.nonCompliantResourceCount()) && Objects.equals(this.complianceSummaryTimestamp(), other.complianceSummaryTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"ComplianceSummary").add("CompliantResourceCount", (Object)this.compliantResourceCount()).add("NonCompliantResourceCount", (Object)this.nonCompliantResourceCount()).add("ComplianceSummaryTimestamp", (Object)this.complianceSummaryTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompliantResourceCount": {
                return Optional.of(clazz.cast(this.compliantResourceCount()));
            }
            case "NonCompliantResourceCount": {
                return Optional.of(clazz.cast(this.nonCompliantResourceCount()));
            }
            case "ComplianceSummaryTimestamp": {
                return Optional.of(clazz.cast(this.complianceSummaryTimestamp()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ComplianceContributorCount compliantResourceCount;
        private ComplianceContributorCount nonCompliantResourceCount;
        private Instant complianceSummaryTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceSummary model) {
            this.compliantResourceCount(model.compliantResourceCount);
            this.nonCompliantResourceCount(model.nonCompliantResourceCount);
            this.complianceSummaryTimestamp(model.complianceSummaryTimestamp);
        }

        public final ComplianceContributorCount.Builder getCompliantResourceCount() {
            return this.compliantResourceCount != null ? this.compliantResourceCount.toBuilder() : null;
        }

        @Override
        public final Builder compliantResourceCount(ComplianceContributorCount compliantResourceCount) {
            this.compliantResourceCount = compliantResourceCount;
            return this;
        }

        public final void setCompliantResourceCount(ComplianceContributorCount.BuilderImpl compliantResourceCount) {
            this.compliantResourceCount = compliantResourceCount != null ? compliantResourceCount.build() : null;
        }

        public final ComplianceContributorCount.Builder getNonCompliantResourceCount() {
            return this.nonCompliantResourceCount != null ? this.nonCompliantResourceCount.toBuilder() : null;
        }

        @Override
        public final Builder nonCompliantResourceCount(ComplianceContributorCount nonCompliantResourceCount) {
            this.nonCompliantResourceCount = nonCompliantResourceCount;
            return this;
        }

        public final void setNonCompliantResourceCount(ComplianceContributorCount.BuilderImpl nonCompliantResourceCount) {
            this.nonCompliantResourceCount = nonCompliantResourceCount != null ? nonCompliantResourceCount.build() : null;
        }

        public final Instant getComplianceSummaryTimestamp() {
            return this.complianceSummaryTimestamp;
        }

        @Override
        public final Builder complianceSummaryTimestamp(Instant complianceSummaryTimestamp) {
            this.complianceSummaryTimestamp = complianceSummaryTimestamp;
            return this;
        }

        public final void setComplianceSummaryTimestamp(Instant complianceSummaryTimestamp) {
            this.complianceSummaryTimestamp = complianceSummaryTimestamp;
        }

        public ComplianceSummary build() {
            return new ComplianceSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComplianceSummary> {
        public Builder compliantResourceCount(ComplianceContributorCount var1);

        default public Builder compliantResourceCount(Consumer<ComplianceContributorCount.Builder> compliantResourceCount) {
            return this.compliantResourceCount((ComplianceContributorCount)((ComplianceContributorCount.Builder)ComplianceContributorCount.builder().apply(compliantResourceCount)).build());
        }

        public Builder nonCompliantResourceCount(ComplianceContributorCount var1);

        default public Builder nonCompliantResourceCount(Consumer<ComplianceContributorCount.Builder> nonCompliantResourceCount) {
            return this.nonCompliantResourceCount((ComplianceContributorCount)((ComplianceContributorCount.Builder)ComplianceContributorCount.builder().apply(nonCompliantResourceCount)).build());
        }

        public Builder complianceSummaryTimestamp(Instant var1);
    }
}

