/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.config.model.Scope;

public class ScopeUnmarshaller
implements Unmarshaller<Scope, JsonUnmarshallerContext> {
    private static ScopeUnmarshaller INSTANCE;

    public Scope unmarshall(JsonUnmarshallerContext context) throws Exception {
        Scope.Builder scopeBuilder = Scope.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ComplianceResourceTypes", targetDepth)) {
                    context.nextToken();
                    scopeBuilder.complianceResourceTypes(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("TagKey", targetDepth)) {
                    context.nextToken();
                    scopeBuilder.tagKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TagValue", targetDepth)) {
                    context.nextToken();
                    scopeBuilder.tagValue((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ComplianceResourceId", targetDepth)) {
                    context.nextToken();
                    scopeBuilder.complianceResourceId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Scope)scopeBuilder.build();
    }

    public static ScopeUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ScopeUnmarshaller();
        }
        return INSTANCE;
    }
}

