/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.services.config.transform.ResourceIdentifierMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceIdentifier
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceIdentifier> {
    private final String resourceType;
    private final String resourceId;
    private final String resourceName;
    private final Date resourceDeletionTime;

    private ResourceIdentifier(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceName = builder.resourceName;
        this.resourceDeletionTime = builder.resourceDeletionTime;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public Date resourceDeletionTime() {
        return this.resourceDeletionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.resourceId() == null ? 0 : this.resourceId().hashCode());
        hashCode = 31 * hashCode + (this.resourceName() == null ? 0 : this.resourceName().hashCode());
        hashCode = 31 * hashCode + (this.resourceDeletionTime() == null ? 0 : this.resourceDeletionTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceIdentifier)) {
            return false;
        }
        ResourceIdentifier other = (ResourceIdentifier)obj;
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.resourceName() == null ^ this.resourceName() == null) {
            return false;
        }
        if (other.resourceName() != null && !other.resourceName().equals(this.resourceName())) {
            return false;
        }
        if (other.resourceDeletionTime() == null ^ this.resourceDeletionTime() == null) {
            return false;
        }
        return other.resourceDeletionTime() == null || other.resourceDeletionTime().equals(this.resourceDeletionTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.resourceName() != null) {
            sb.append("ResourceName: ").append(this.resourceName()).append(",");
        }
        if (this.resourceDeletionTime() != null) {
            sb.append("ResourceDeletionTime: ").append(this.resourceDeletionTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String resourceId;
        private String resourceName;
        private Date resourceDeletionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceIdentifier model) {
            this.setResourceType(model.resourceType);
            this.setResourceId(model.resourceId);
            this.setResourceName(model.resourceName);
            this.setResourceDeletionTime(model.resourceDeletionTime);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final void setResourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final Date getResourceDeletionTime() {
            return this.resourceDeletionTime;
        }

        @Override
        public final Builder resourceDeletionTime(Date resourceDeletionTime) {
            this.resourceDeletionTime = StandardMemberCopier.copy((Date)resourceDeletionTime);
            return this;
        }

        public final void setResourceDeletionTime(Date resourceDeletionTime) {
            this.resourceDeletionTime = StandardMemberCopier.copy((Date)resourceDeletionTime);
        }

        public ResourceIdentifier build() {
            return new ResourceIdentifier(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceIdentifier> {
        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceId(String var1);

        public Builder resourceName(String var1);

        public Builder resourceDeletionTime(Date var1);
    }
}

