/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.config.model.ResourceTypesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetComplianceSummaryByResourceTypeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetComplianceSummaryByResourceTypeRequest> {
    private final List<String> resourceTypes;

    private GetComplianceSummaryByResourceTypeRequest(BuilderImpl builder) {
        this.resourceTypes = builder.resourceTypes;
    }

    public List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceTypes() == null ? 0 : this.resourceTypes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceSummaryByResourceTypeRequest)) {
            return false;
        }
        GetComplianceSummaryByResourceTypeRequest other = (GetComplianceSummaryByResourceTypeRequest)((Object)obj);
        if (other.resourceTypes() == null ^ this.resourceTypes() == null) {
            return false;
        }
        return other.resourceTypes() == null || other.resourceTypes().equals(this.resourceTypes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.resourceTypes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> resourceTypes = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceSummaryByResourceTypeRequest model) {
            this.setResourceTypes(model.resourceTypes);
        }

        public final Collection<String> getResourceTypes() {
            return this.resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            if (this.resourceTypes == null) {
                this.resourceTypes = new SdkInternalList(resourceTypes.length);
            }
            for (String e : resourceTypes) {
                this.resourceTypes.add(e);
            }
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        @SafeVarargs
        public final void setResourceTypes(String ... resourceTypes) {
            if (this.resourceTypes == null) {
                this.resourceTypes = new SdkInternalList(resourceTypes.length);
            }
            for (String e : resourceTypes) {
                this.resourceTypes.add(e);
            }
        }

        public GetComplianceSummaryByResourceTypeRequest build() {
            return new GetComplianceSummaryByResourceTypeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetComplianceSummaryByResourceTypeRequest> {
        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);
    }
}

